/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.auth;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BearerTokenFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BearerTokenFactory.class);

    private BearerTokenFactory() {
        throw new UnsupportedOperationException();
    }

    public static String extractToken(HttpServletRequest request) {
        String TOKEN_PREFIX = "Bearer ";
        String HEADER_KEY = "Authorization";
        String headerValue = request.getHeader("Authorization");
        if (StringUtils.isBlank((CharSequence)headerValue)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Header value '{}' is blank.", (Object)"Authorization");
            }
            return null;
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)headerValue, (CharSequence)"Bearer ")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Header value does not start with '{}'.", (Object)"Bearer ");
            }
            return null;
        }
        return StringUtils.substringAfterLast((String)headerValue, (String)" ");
    }
}

