/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.account;

import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.exception.domain.MultibankingError;
import de.adorsys.multibanking.service.BookingService;
import de.adorsys.multibanking.web.annotation.UserResource;
import de.adorsys.multibanking.web.common.BankAccountBasedController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@UserResource
@RestController
@RequestMapping(path={"/api/v1/bankaccesses/{accessId}/accounts/{accountId}/bookings"})
@Api(value="/api/v1/bankaccesses/{accessId}/accounts/{accountId}/bookings", tags={"MB-006 - Bookings"}, description="Enable the laoding of a booking files given the booking period. The list of available booking periods is contained in the user data object.")
public class BookingController
extends BankAccountBasedController {
    public static final String BASE_PATH = "/api/v1/bankaccesses/{accessId}/accounts/{accountId}/bookings";
    @Autowired
    private BookingService bookingService;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"}, params={"period"})
    @ApiOperation(value="Load bookings", notes="Returns the booking file of the given booking period. The list of available booking periods is contained in the user data object.")
    @ApiResponses(value={@ApiResponse(code=200, message="Ok", response=BookingEntity[].class), @ApiResponse(code=401, message="user.unauthenticated : User not authenticated", response=MultibankingError.class), @ApiResponse(code=412, message="User with Id [{1}] not found. First create the user.", response=MultibankingError.class), @ApiResponse(code=404, message="Resource [{0}] with id [{1}] not found.", response=MultibankingError.class), @ApiResponse(code=400, message="unknown.booking.file: Booking file for provided address unexistent. Review the list of existing booking periods.", response=MultibankingError.class)})
    @ResponseBody
    public ResponseEntity<ByteArrayResource> getBookings(@ApiParam(name="accessId", required=true, value="The identifier of the bank access container the bank account.", example="3c149076-13c4-4190-ace3-e30bf8f61526") @PathVariable String accessId, @ApiParam(name="accountId", required=true, value="The identifier of the bank account in the scope of the containing bank access.", example="DE81199999993528307800") @PathVariable String accountId, @ApiParam(name="period", required=true, value="The period file to be retured. The list of available booking periods is contained in the user data object.", example="2018") @RequestParam(required=true, name="period") String period) {
        this.checkBankAccountExists(accessId, accountId);
        this.checkSynch(accessId, accountId);
        return this.loadBytesForWeb(this.bookingService.getBookings(accessId, accountId, period));
    }
}

