/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.account;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.exception.domain.MultibankingError;
import de.adorsys.multibanking.web.annotation.UserResource;
import de.adorsys.multibanking.web.common.BankAccessBasedController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@UserResource
@RestController
@RequestMapping(path={"/api/v1/bankaccesses"})
@Api(value="/api/v1/bankaccesses", tags={"MB-004 - Bank Access"}, description="Manages information associating a user to an online banking account. Like bank code, bank login and corresponding password. A bank access is part of the user data object. So user the user data endpoint to load all bank accesses of this user.")
public class BankAccessController
extends BankAccessBasedController {
    public static final String BASE_PATH = "/api/v1/bankaccesses";
    private static final Logger LOGGER = LoggerFactory.getLogger(BankAccessController.class);

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json;charset=UTF-8"})
    @ApiOperation(value="Create bank access", notes="Creates and adds a new bank access to the list of bank accesses of this user. Returns the location url for loading the updated user data object.")
    @ApiResponses(value={@ApiResponse(code=201, responseHeaders={@ResponseHeader(name="location", description="Url for loading the updated user data file")}, message="Provided bank access successfuly created. Reload user data object."), @ApiResponse(code=401, message="user.unauthenticated : User not authenticated", response=MultibankingError.class), @ApiResponse(code=412, message="User with Id [{1}] not found. First create the user.", response=MultibankingError.class), @ApiResponse(code=403, message="credential.invalid: Credentials not valid for provided bank code", response=MultibankingError.class), @ApiResponse(code=409, message="bankaccess.already.exists: A bank access with provided bank code already exists.", response=MultibankingError.class), @ApiResponse(code=400, message="Invalid request. See response content.", response=MultibankingError.class)})
    public HttpEntity<Void> createBankaccess(@ApiParam(name="bankAccess", required=true, value="The bank access data containing (Bank Code, Bank name, Bank login, PIN") @RequestBody(required=true) BankAccessEntity bankAccess) {
        this.bankAccessService.createBankAccess(bankAccess);
        LOGGER.debug("Bank access created for " + this.userId());
        return new ResponseEntity((MultiValueMap)this.userDataLocationHeader(), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{accessId}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete bank access", notes="Deletes the bank access with the given id, also deletes all associated credentials, accounts and bookings. Returns the location url for loading the updated user data object.")
    @ApiResponses(value={@ApiResponse(code=204, responseHeaders={@ResponseHeader(name="location", description="Url for loading the updated user data file")}, message="Bank access with provided id successfuly deleted"), @ApiResponse(code=410, responseHeaders={@ResponseHeader(name="location", description="Url for loading the updated user data file")}, message="Bank access with provided id is gone"), @ApiResponse(code=401, message="user.unauthenticated : User not authenticated", response=MultibankingError.class), @ApiResponse(code=412, message="User with Id [{1}] not found. First create the user.", response=MultibankingError.class)})
    public HttpEntity<Void> deleteBankAccess(@ApiParam(name="accessId", required=true, value="The identifier of the bank access to delete.", example="3c149076-13c4-4190-ace3-e30bf8f61526") @PathVariable String accessId) {
        if (this.bankAccessService.deleteBankAccess(accessId)) {
            LOGGER.debug("Bank Access [{}] deleted.", (Object)accessId);
            return new ResponseEntity((MultiValueMap)this.userDataLocationHeader(), HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity(HttpStatus.GONE);
    }
}

