/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.producer;

import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.onlinebanking.mock.MockBanking;
import domain.BankApi;
import figo.FigoBanking;
import finapi.FinapiBanking;
import hbci4java.Hbci4JavaBanking;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import spi.OnlineBankingService;

@Service
public class OnlineBankingServiceProducer {
    @Value(value="${defaultBankApi:HBCI}")
    String defaultBankApi;
    @Autowired
    BankService bankService;
    @Autowired
    private MockBanking mockBanking;
    private Hbci4JavaBanking hbci4JavaBanking = new Hbci4JavaBanking();
    private FigoBanking figoBanking = new FigoBanking(BankApi.FIGO);
    private FigoBanking figoBankingAlternative = new FigoBanking(BankApi.FIGO_ALTERNATIVE);
    private FinapiBanking finapiBanking = new FinapiBanking();

    private BankApi getBankApiForBlz(String blz) {
        BankEntity bankInfoEntity = this.bankService.findByBankCode(blz).orElse(null);
        if (bankInfoEntity != null && bankInfoEntity.getBankApi() != null) {
            return bankInfoEntity.getBankApi();
        }
        return BankApi.valueOf((String)this.defaultBankApi);
    }

    public OnlineBankingService getBankingService(String bankCode) {
        BankApi bankApi = this.getBankApiForBlz(bankCode);
        return this.getBankingService(bankApi);
    }

    public OnlineBankingService getBankingService(BankApi bankApi) {
        switch (bankApi) {
            case HBCI: {
                return this.hbci4JavaBanking;
            }
            case FIGO: {
                return this.figoBanking;
            }
            case FIGO_ALTERNATIVE: {
                return this.figoBankingAlternative;
            }
            case FINAPI: {
                return this.finapiBanking;
            }
            case MOCK: {
                return this.mockBanking;
            }
        }
        throw new IllegalStateException("unsupported bank api");
    }
}

