/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.crypto;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.adorsys.cryptoutils.exceptions.BaseException;

public class KeyGen {
    public static OctetSequenceKey newAESKey(String keyId, EncryptionMethod encryptionMethod) {
        KeyGenerator keyGenerator;
        int keySize = 0;
        if (encryptionMethod.getName().contains("128")) {
            keySize = 128;
        } else if (encryptionMethod.getName().contains("192")) {
            keySize = 192;
        } else if (encryptionMethod.getName().contains("256")) {
            keySize = 256;
        } else {
            throw new BaseException("Unsupported Keysize: " + encryptionMethod.getName() + ". Use algorithm with key size 128 or 192 or 256");
        }
        try {
            keyGenerator = KeyGenerator.getInstance("AES");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BaseException((Throwable)e);
        }
        keyGenerator.init(keySize);
        SecretKey secretKey = keyGenerator.generateKey();
        return new OctetSequenceKey.Builder(secretKey).keyID(keyId).algorithm((Algorithm)JWEAlgorithm.DIR).keyUse(KeyUse.ENCRYPTION).build();
    }
}

