/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.base;

import de.adorsys.multibanking.domain.common.IdentityIf;
import de.adorsys.multibanking.utils.Ids;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class ListUtils {
    public static <T extends IdentityIf> Optional<T> find(String id, List<T> list) {
        return list.stream().filter(t -> Ids.eq(id, t.getId())).findFirst();
    }

    public static <T extends IdentityIf> List<T> setId(List<T> inputList) {
        inputList.stream().forEach(n -> Ids.id(n));
        return inputList;
    }

    public static <T extends IdentityIf> List<T> updateList(List<T> inputList, List<T> persList) {
        List foundElements = inputList.stream().filter(i -> persList.contains(i)).collect(Collectors.toList());
        ArrayList<T> newList = new ArrayList<T>(inputList);
        newList.removeAll(foundElements);
        foundElements.stream().forEach(e -> {
            int indexOf = persList.indexOf(e);
            persList.set(indexOf, e);
        });
        ArrayList finalList = new ArrayList(persList);
        newList.stream().forEach(n -> {
            Ids.id(n);
            finalList.add(n);
        });
        return finalList;
    }

    public static <T extends IdentityIf> List<T> deleteList(List<T> inputList, List<T> persList) {
        persList.removeAll(inputList);
        return persList;
    }

    public static <T extends IdentityIf> List<T> deleteListById(List<String> inputIdList, List<T> persList) {
        List inputList = persList.stream().filter(e -> inputIdList.contains(e.getId())).collect(Collectors.toList());
        if (!inputList.isEmpty()) {
            persList.removeAll(inputList);
        }
        return persList;
    }
}

