/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.base;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.auth.CacheEntry;
import de.adorsys.multibanking.auth.UserContext;
import de.adorsys.multibanking.auth.UserContextCache;
import de.adorsys.multibanking.service.base.CacheBasedInterface;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheBasedService
implements CacheBasedInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheBasedService.class);
    private ObjectMapper objectMapper;
    private DocumentSafeService documentSafeService;

    protected abstract UserContext user();

    public UserContextCache userContextCache() {
        return new UserContextCache(this.user());
    }

    public void enableCaching() {
        this.user().setCacheEnabled(true);
    }

    protected CacheBasedService(ObjectMapper objectMapper, DocumentSafeService documentSafeService) {
        this.objectMapper = objectMapper;
        this.documentSafeService = documentSafeService;
    }

    public UserIDAuth auth() {
        return this.user().getAuth();
    }

    @Override
    public <T> Optional<T> load(DocumentFQN documentFQN, TypeReference<T> valueType) {
        LOGGER.debug("load: " + documentFQN);
        this.user().getRequestCounter().load(documentFQN);
        Optional<CacheEntry<T>> cacheHit = this.userContextCache().cacheHit(documentFQN, valueType);
        if (cacheHit.isPresent()) {
            LOGGER.debug("loaded from cache: " + documentFQN);
            this.user().getRequestCounter().cacheHit(documentFQN);
            return cacheHit.get().getEntry();
        }
        if (!this.documentSafeService.documentExists(this.user().getAuth(), documentFQN)) {
            LOGGER.debug("load, doc not found: " + documentFQN);
            return Optional.empty();
        }
        try {
            LOGGER.debug("loading from file: " + documentFQN);
            Optional<Object> ot = Optional.of(this.objectMapper.readValue(this.documentSafeService.readDocument(this.user().getAuth(), documentFQN).getDocumentContent().getValue(), valueType));
            this.userContextCache().cacheHit(documentFQN, valueType, ot, false);
            return ot;
        }
        catch (IOException e) {
            throw new BaseException((Throwable)e);
        }
    }

    @Override
    public <T> void store(DocumentFQN documentFQN, TypeReference<T> valueType, T entity) {
        LOGGER.debug("store: " + documentFQN + " cache enabled:" + this.user().isCacheEnabled());
        this.user().getRequestCounter().store(documentFQN);
        boolean cacheHit = this.userContextCache().cacheHit(documentFQN, valueType, Optional.ofNullable(entity), true);
        if (!cacheHit) {
            LOGGER.debug("flush im store " + documentFQN);
            this.flush(documentFQN, entity);
        } else {
            LOGGER.debug("No flush, will store on cache flush " + documentFQN);
        }
    }

    @Override
    public <T> boolean documentExists(DocumentFQN documentFQN, TypeReference<T> valueType) {
        if (this.userContextCache().isCached(documentFQN, valueType)) {
            return true;
        }
        return this.documentSafeService.documentExists(this.auth(), documentFQN);
    }

    @Override
    public <T> boolean deleteDocument(DocumentFQN documentFQN, TypeReference<T> valueType) {
        LOGGER.debug("deleteDocument " + documentFQN);
        Optional<CacheEntry<T>> removed = this.userContextCache().remove(documentFQN, valueType);
        boolean docExist = false;
        try {
            docExist = this.documentSafeService.documentExists(this.auth(), documentFQN);
        }
        catch (BaseException b) {
            LOGGER.warn("error checking existence of Document " + documentFQN);
        }
        if (docExist) {
            this.documentSafeService.deleteDocument(this.auth(), documentFQN);
            return true;
        }
        return removed != null;
    }

    @Override
    public void deleteDirectory(DocumentDirectoryFQN dirFQN) {
        this.clearCached(dirFQN);
        this.documentSafeService.deleteFolder(this.auth(), dirFQN);
    }

    @Override
    public void flush() {
        if (!this.user().isCacheEnabled()) {
            return;
        }
        Collection<Map<DocumentFQN, CacheEntry<?>>> values = this.user().getCache().values();
        LOGGER.debug("Flushing cache: " + this.user().getAuth().getUserID() + " Objects in cache: " + values.size());
        for (Map<DocumentFQN, CacheEntry<?>> map : values) {
            Collection<CacheEntry<?>> collection = map.values();
            for (CacheEntry<?> cacheEntry : collection) {
                LOGGER.debug("Cache entry pre flush: " + cacheEntry.getDocFqn());
                if (cacheEntry.isDirty()) {
                    cacheEntry.setDirty(false);
                    LOGGER.debug("Cache entry pre flush : dirty: " + cacheEntry.getDocFqn());
                    if (cacheEntry.getEntry().isPresent()) {
                        LOGGER.debug("Cache entry pre flush : present: " + cacheEntry.getDocFqn());
                        this.flush(cacheEntry.getDocFqn(), cacheEntry.getEntry().get());
                        continue;
                    }
                    LOGGER.debug("Cache entry pre flush : absent. File will be deleted: " + cacheEntry.getDocFqn());
                    this.documentSafeService.deleteDocument(this.auth(), cacheEntry.getDocFqn());
                    continue;
                }
                LOGGER.debug("Cache entry pre flush : clean. No file write : " + cacheEntry.getDocFqn());
            }
        }
        LOGGER.debug("Flushed cache: " + this.user().getAuth().getUserID());
    }

    private void clearCached(DocumentDirectoryFQN dir) {
        LOGGER.debug("clearing Cached " + dir);
        this.userContextCache().clearCached(dir);
    }

    private <T> void flush(DocumentFQN documentFQN, T entity) {
        DocumentContent documentContent;
        LOGGER.debug("flushing: " + documentFQN);
        this.user().getRequestCounter().flush(documentFQN);
        try {
            documentContent = new DocumentContent(this.objectMapper.writeValueAsBytes(entity));
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        DSDocument dsDocument = new DSDocument(documentFQN, documentContent, null);
        this.documentSafeService.storeDocument(this.auth(), dsDocument);
    }
}

