/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.analytics;

import de.adorsys.multibanking.service.base.SystemObjectService;
import de.adorsys.multibanking.utils.FQNUtils;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemImageService {
    @Autowired
    private SystemObjectService sos;
    @Autowired
    private DocumentSafeService documentSafeService;

    public boolean hasImage(String imageName) {
        return this.sos.documentExists(FQNUtils.imageFQN(imageName), null);
    }

    public DSDocument loadStaticImage(String imageName) {
        return this.documentSafeService.readDocument(this.sos.auth(), FQNUtils.imageFQN(imageName));
    }

    public void storeStaticImage(String imageName, byte[] data) {
        DocumentContent documentContent = new DocumentContent(data);
        DSDocument dsDocument = new DSDocument(FQNUtils.imageFQN(imageName), documentContent, null);
        this.documentSafeService.storeDocument(this.sos.auth(), dsDocument);
    }
}

