/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.analytics;

import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.service.analytics.CustomBookingRuleService;
import de.adorsys.multibanking.service.analytics.SmartanalyticsMapper;
import de.adorsys.smartanalytics.api.AnalyticsRequest;
import de.adorsys.smartanalytics.api.AnalyticsResult;
import de.adorsys.smartanalytics.api.GroupConfig;
import de.adorsys.smartanalytics.api.Rule;
import de.adorsys.smartanalytics.api.SmartAnalyticsFacade;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SmartAnalyticsService {
    @Autowired
    private CustomBookingRuleService bookingRuleService;
    @Autowired
    @Qualifier(value="contractBlacklist")
    private List<String> contractBlacklist;
    @Autowired
    private GroupConfig groupConfig;
    @Autowired
    private SmartAnalyticsFacade smartAnalyticsFacade;

    public AnalyticsResult analyzeBookings(String userId, List<BookingEntity> bookings) {
        bookings.forEach(bookingEntity -> bookingEntity.setBookingCategory(null));
        List<Rule> customRules = this.loadUserRules(userId);
        AnalyticsRequest analyticsRequest = this.createAnalyticsRequest(bookings, customRules);
        return this.analyzeBookingsRemote(analyticsRequest);
    }

    private AnalyticsResult analyzeBookingsRemote(AnalyticsRequest analyticsRequest) {
        return this.smartAnalyticsFacade.analyzeBookings(analyticsRequest);
    }

    private List<Rule> loadUserRules(String userId) {
        return this.bookingRuleService.loadRules().stream().map(customRuleEntity -> {
            Rule smartanalyticsRule = new Rule();
            BeanUtils.copyProperties((Object)customRuleEntity, (Object)smartanalyticsRule);
            return smartanalyticsRule;
        }).collect(Collectors.toList());
    }

    private AnalyticsRequest createAnalyticsRequest(List<BookingEntity> bookings, List<Rule> customRules) {
        return AnalyticsRequest.builder().bookings(SmartanalyticsMapper.convertInput(bookings)).groupConfig(this.groupConfig).contractBlackListMatcher(this.contractBlacklist).customRules(customRules).build();
    }
}

