/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.analytics;

import de.adorsys.multibanking.domain.AnonymizedBookingEntity;
import de.adorsys.multibanking.domain.BookingEntity;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class AnonymizationService {
    public List<AnonymizedBookingEntity> anonymizeAndStoreBookingsAsync(List<BookingEntity> bookingEntities) {
        List uncategorizedBookings = bookingEntities.stream().filter(bookingEntity -> bookingEntity.getBookingCategory() == null && (bookingEntity.getCreditorId() != null || bookingEntity.getOtherAccount() != null && bookingEntity.getOtherAccount().getIban() != null || bookingEntity.getUsage() != null)).collect(Collectors.toList());
        return uncategorizedBookings.stream().map(bookingEntity -> this.anonymizeBooking((BookingEntity)bookingEntity)).collect(Collectors.toList());
    }

    private AnonymizedBookingEntity anonymizeBooking(BookingEntity bookingEntity) {
        AnonymizedBookingEntity anonymizedBookingEntity = new AnonymizedBookingEntity();
        if (bookingEntity.getAmount().compareTo(BigDecimal.ZERO) == 1) {
            anonymizedBookingEntity.setAmount(new BigDecimal(1));
        } else {
            anonymizedBookingEntity.setAmount(new BigDecimal(-1));
        }
        anonymizedBookingEntity.setCreditorId(bookingEntity.getCreditorId());
        anonymizedBookingEntity.setPurpose(bookingEntity.getUsage());
        anonymizedBookingEntity.setId(bookingEntity.getId());
        if (bookingEntity.getOtherAccount() != null) {
            anonymizedBookingEntity.setOtherAccountIBAN(bookingEntity.getOtherAccount().getIban());
        }
        return anonymizedBookingEntity;
    }
}

