/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.PaymentEntity;
import de.adorsys.multibanking.exception.MissingPinException;
import de.adorsys.multibanking.exception.PaymentException;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.UserDataService;
import de.adorsys.multibanking.service.base.ListUtils;
import de.adorsys.multibanking.service.base.UserObjectService;
import de.adorsys.multibanking.service.producer.OnlineBankingServiceProducer;
import de.adorsys.multibanking.utils.FQNUtils;
import domain.BankAccess;
import domain.BankApiUser;
import domain.Payment;
import exception.HbciException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import spi.OnlineBankingService;

@Service
public class PaymentService {
    @Autowired
    private UserObjectService uos;
    @Autowired
    private OnlineBankingServiceProducer bankingServiceProducer;
    @Autowired
    private UserDataService uds;
    @Autowired
    private BankService bankService;

    public PaymentEntity createPayment(BankAccessEntity bankAccess, BankAccountEntity bankAccount, String pin, Payment payment) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        BankApiUser bankApiUser = this.uds.checkApiRegistration(bankingService.bankApi(), bankAccess.getBankCode());
        String string = pin = pin == null ? bankAccess.getPin() : pin;
        if (pin == null) {
            throw new MissingPinException();
        }
        String mappedBlz = this.bankService.findByBankCode(bankAccess.getBankCode()).orElseThrow(() -> new ResourceNotFoundException(BankEntity.class, bankAccess.getBankCode())).getBlzHbci();
        try {
            bankingService.createPayment(bankApiUser, (BankAccess)bankAccess, mappedBlz, pin, payment);
        }
        catch (HbciException e) {
            throw new PaymentException(e.getMessage());
        }
        PaymentEntity pe = new PaymentEntity();
        BeanUtils.copyProperties((Object)payment, (Object)pe);
        pe.setUserId(bankAccess.getUserId());
        pe.setSenderAccountNumber(bankAccount.getAccountNumber());
        pe.setSenderIban(bankAccount.getIban());
        pe.setSenderBic(bankAccount.getBic());
        pe.setCreatedDateTime(new Date());
        pe.setBankAccessId(bankAccess.getId());
        pe.setBankAccountId(bankAccount.getId());
        this.create(pe);
        return pe;
    }

    public void submitPayment(PaymentEntity paymentEntity, String bankCode, String tan) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankCode);
        try {
            bankingService.submitPayment((Payment)paymentEntity, null, tan);
        }
        catch (HbciException e) {
            throw new PaymentException(e.getMessage());
        }
        this.delete(paymentEntity);
    }

    public Optional<PaymentEntity> findPayment(String accessId, String accountId, String paymentId) {
        List persList = this.uos.load(FQNUtils.paymentsFQN(accessId, accountId), PaymentService.listType()).orElse(Collections.emptyList());
        return ListUtils.find(paymentId, persList);
    }

    private void create(PaymentEntity payment) {
        List<Object> persList = this.uos.load(PaymentService.paymentsFQN(payment), PaymentService.listType()).orElse(Collections.emptyList());
        persList = ListUtils.updateList(Collections.singletonList(payment), persList);
        this.uos.store(PaymentService.paymentsFQN(payment), PaymentService.listType(), persList);
    }

    private boolean delete(PaymentEntity payment) {
        List persList = this.uos.load(PaymentService.paymentsFQN(payment), PaymentService.listType()).orElse(Collections.emptyList());
        List<PaymentEntity> newPersList = ListUtils.deleteList(Collections.singletonList(payment), persList);
        this.uos.store(PaymentService.paymentsFQN(payment), PaymentService.listType(), persList);
        return persList.size() - newPersList.size() != 0;
    }

    private static DocumentFQN paymentsFQN(PaymentEntity target) {
        return FQNUtils.paymentsFQN(target.getBankAccessId(), target.getBankAccountId());
    }

    private static TypeReference<List<PaymentEntity>> listType() {
        return new TypeReference<List<PaymentEntity>>(){};
    }
}

