/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.service.base.ListUtils;
import de.adorsys.multibanking.service.base.SystemObjectService;
import de.adorsys.multibanking.utils.FQNUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BankService {
    @Autowired
    private SystemObjectService sos;
    @Autowired
    private DocumentSafeService documentSafeService;
    private final YAMLFactory ymlFactory = new YAMLFactory();
    private final ObjectMapper ymlObjectMapper = new ObjectMapper((JsonFactory)this.ymlFactory);

    public Optional<BankEntity> findByBankCode(String bankCode) {
        return ListUtils.find(bankCode, this.sos.load(FQNUtils.banksFQN(), BankService.listType()).orElse(Collections.emptyList()));
    }

    public List<BankEntity> load() {
        return this.sos.load(FQNUtils.banksFQN(), BankService.listType()).orElse(Collections.emptyList());
    }

    public DSDocument loadDocument() {
        return this.documentSafeService.readDocument(this.sos.auth(), FQNUtils.banksFQN());
    }

    public void importBanks(InputStream inputStream) throws IOException {
        List banks = (List)this.ymlObjectMapper.readValue(inputStream, (TypeReference)new TypeReference<List<BankEntity>>(){});
        banks.stream().forEach(b -> b.setId(b.getBankCode()));
        this.sos.store(FQNUtils.banksFQN(), BankService.listType(), banks);
    }

    private static TypeReference<List<BankEntity>> listType() {
        return new TypeReference<List<BankEntity>>(){};
    }
}

