/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.domain.AccountAnalyticsEntity;
import de.adorsys.multibanking.domain.AccountSynchPref;
import de.adorsys.multibanking.domain.BankAccessCredentials;
import de.adorsys.multibanking.domain.BankAccessData;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccountData;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.ContractEntity;
import de.adorsys.multibanking.domain.StandingOrderEntity;
import de.adorsys.multibanking.domain.UserData;
import de.adorsys.multibanking.exception.BankAccessAlreadyExistException;
import de.adorsys.multibanking.exception.InvalidBankAccessException;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.service.BankAccessService;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.UserDataService;
import de.adorsys.multibanking.service.producer.OnlineBankingServiceProducer;
import de.adorsys.multibanking.utils.Ids;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.LoadAccountInformationRequest;
import domain.StandingOrder;
import exception.InvalidPinException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import spi.OnlineBankingService;

@Service
public class BankAccountService {
    private static final Logger log = LoggerFactory.getLogger(BankAccessService.class);
    @Autowired
    private UserDataService uds;
    @Autowired
    private OnlineBankingServiceProducer bankingServiceProducer;
    @Autowired
    private BankService bankService;

    public void synchBankAccounts(BankAccessEntity bankAccess, BankAccessCredentials credentials) {
        List<BankAccountEntity> bankAccounts = this.loadFromBankingAPI(bankAccess, credentials, null);
        if (bankAccounts.size() == 0) {
            throw new InvalidBankAccessException(bankAccess.getBankCode());
        }
        UserData userData = this.uds.load();
        BankAccessData bankAccessData = userData.bankAccessDataOrException(bankAccess.getId());
        List<BankAccountData> bankAccountData = bankAccessData.getBankAccounts();
        bankAccounts.forEach(account -> {
            account.bankAccessId(bankAccess.getId());
            Optional<BankAccountData> accountData = bankAccessData.getBankAccount(account.getId());
            if (!accountData.isPresent()) {
                accountData = Optional.of(new BankAccountData());
                bankAccountData.add(accountData.get());
            }
            accountData.get().setBankAccount((BankAccountEntity)account);
        });
        this.uds.store(userData);
        log.info("[{}] accounts for connection [{}] created.", (Object)bankAccounts.size(), (Object)bankAccess.getId());
    }

    public List<BankAccountEntity> loadFromBankingAPI(BankAccessEntity bankAccess, BankAccessCredentials credentials, BankApi bankApi) {
        List bankAccounts;
        OnlineBankingService onlineBankingService;
        OnlineBankingService onlineBankingService2 = onlineBankingService = bankApi != null ? this.bankingServiceProducer.getBankingService(bankApi) : this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        if (!onlineBankingService.bankSupported(bankAccess.getBankCode())) {
            throw new InvalidBankAccessException(bankAccess.getBankCode());
        }
        BankApiUser bankApiUser = this.uds.checkApiRegistration(bankApi, bankAccess.getBankCode());
        String blzHbci = this.bankService.findByBankCode(bankAccess.getBankCode()).orElseThrow(() -> new ResourceNotFoundException(BankEntity.class, bankAccess.getBankCode())).getBlzHbci();
        try {
            bankAccounts = Optional.ofNullable(onlineBankingService.loadBankAccounts(LoadAccountInformationRequest.builder().bankApiUser(bankApiUser).bankAccess((BankAccess)bankAccess).bankCode(blzHbci).pin(credentials.getPin()).storePin(false).updateTanTransportTypes(true).build())).map(ba -> ba.getBankAccounts()).orElse(Collections.EMPTY_LIST);
        }
        catch (InvalidPinException e) {
            throw new de.adorsys.multibanking.exception.InvalidPinException(bankAccess.getId());
        }
        if (onlineBankingService.bankApi() == BankApi.FIGO) {
            this.filterAccounts(bankAccess, onlineBankingService, bankAccounts);
        }
        ArrayList<BankAccountEntity> bankAccountEntities = new ArrayList<BankAccountEntity>();
        bankAccounts.forEach(source -> {
            BankAccountEntity target = new BankAccountEntity();
            target.id(source.getIban());
            BeanUtils.copyProperties((Object)source, (Object)target);
            target.setUserId(bankAccess.getUserId());
            bankAccountEntities.add(target);
        });
        return bankAccountEntities;
    }

    public BankAccountData loadBankAccount(String accessId, String accountId) {
        UserData userData = this.uds.load();
        return userData.bankAccountDataOrException(accessId, accountId);
    }

    public void saveBankAccount(BankAccountEntity in) {
        UserData userData = this.uds.load();
        userData.bankAccountDataOrException(in.getBankAccessId(), in.getId()).setBankAccount(in);
        this.uds.store(userData);
    }

    public void saveBankAccounts(String accessId, List<BankAccountEntity> accounts) {
        UserData userData = this.uds.load();
        for (BankAccountEntity in : accounts) {
            userData.bankAccountDataOrException(in.getBankAccessId(), in.getId()).setBankAccount(in);
        }
        this.uds.store(userData);
    }

    public boolean exists(String accessId, String accountId) {
        UserData userData = this.uds.load();
        return userData.bankAccessDataOrException(accessId).containsKey(accountId);
    }

    public AccountSynchPref loadAccountLevelSynchPref(String accessId, String accountId) {
        return this.uds.load().bankAccountDataOrException(accessId, accountId).getAccountSynchPref();
    }

    public void storeAccountLevelSynchPref(String accessId, String accountId, AccountSynchPref pref) {
        UserData userData = this.uds.load();
        userData.bankAccountDataOrException(accessId, accountId).setAccountSynchPref(pref);
        this.uds.store(userData);
    }

    public AccountSynchPref loadAccessLevelSynchPref(String accessId) {
        return this.uds.load().bankAccessDataOrException(accessId).getAccountSynchPref();
    }

    public void storeAccessLevelSynchPref(String accessId, AccountSynchPref pref) {
        UserData userData = this.uds.load();
        userData.bankAccessDataOrException(accessId).setAccountSynchPref(pref);
        this.uds.store(userData);
    }

    public AccountSynchPref loadUserLevelSynchPref() {
        return this.uds.load().getAccountSynchPref();
    }

    public void storeUserLevelSynchPref(AccountSynchPref pref) {
        UserData userData = this.uds.load();
        userData.setAccountSynchPref(pref);
        this.uds.store(userData);
    }

    public AccountSynchPref findAccountSynchPref(String accessId, String accountId) {
        AccountSynchPref synchPref = this.loadAccountLevelSynchPref(accessId, accountId);
        if (synchPref == null) {
            synchPref = this.loadAccessLevelSynchPref(accessId);
        }
        if (synchPref == null) {
            synchPref = this.loadUserLevelSynchPref();
        }
        if (synchPref == null) {
            synchPref = new AccountSynchPref();
        }
        return synchPref;
    }

    public void saveStandingOrders(BankAccountEntity bankAccount, List<StandingOrder> standingOrders) {
        UserData userData = this.uds.load();
        Map<String, StandingOrderEntity> standingOrdersMap = userData.bankAccountDataOrException(bankAccount.getBankAccessId(), bankAccount.getId()).getStandingOrders();
        standingOrders.stream().map(standingOrder -> {
            StandingOrderEntity target;
            if (StringUtils.isBlank((CharSequence)standingOrder.getOrderId())) {
                standingOrder.setOrderId(Ids.uuid());
            }
            if ((target = (StandingOrderEntity)standingOrdersMap.get(standingOrder.getOrderId())) == null) {
                target = new StandingOrderEntity();
                Ids.id(target);
                standingOrdersMap.put(standingOrder.getOrderId(), target);
                target.setAccountId(bankAccount.getId());
                target.setUserId(bankAccount.getUserId());
            }
            BeanUtils.copyProperties((Object)standingOrder, (Object)target);
            return target;
        });
        this.uds.store(userData);
    }

    public void saveContracts(String accountId, List<ContractEntity> contractEntities) {
        UserData userData = this.uds.load();
        BankAccountData bankAccountData = this.findBankAccountData(userData, accountId);
        if (bankAccountData == null) {
            throw new ResourceNotFoundException(BankAccountData.class, accountId);
        }
        BankAccountEntity bankAccount = bankAccountData.getBankAccount();
        contractEntities.stream().forEach(c -> {
            c.setAccessId(bankAccount.getBankAccessId());
            c.setUserId(bankAccount.getUserId());
            c.setAccountId(bankAccount.getId());
        });
        bankAccountData.setContracts(new ArrayList<ContractEntity>(contractEntities));
        this.uds.store(userData);
    }

    public void saveAccountAnalytics(String accountId, AccountAnalyticsEntity analytic) {
        UserData userData = this.uds.load();
        BankAccountData bankAccountData = this.findBankAccountData(userData, accountId);
        if (bankAccountData == null) {
            throw new ResourceNotFoundException(BankAccountData.class, accountId);
        }
        BankAccountEntity bankAccount = bankAccountData.getBankAccount();
        analytic.setUserId(bankAccount.getUserId());
        analytic.setAccountId(bankAccount.getId());
        bankAccountData.setAnalytic(analytic);
        this.uds.store(userData);
    }

    private BankAccountData findBankAccountData(UserData userData, String accountId) {
        List<BankAccessData> bankAccesses = userData.getBankAccesses();
        for (BankAccessData b : bankAccesses) {
            Optional<BankAccountData> bankAccount = b.getBankAccount(accountId);
            if (!bankAccount.isPresent()) continue;
            return bankAccount.get();
        }
        return null;
    }

    private void filterAccounts(BankAccessEntity bankAccess, OnlineBankingService onlineBankingService, List<BankAccount> bankAccounts) {
        UserData userData = this.uds.load();
        List<BankAccountData> userBankAccounts = userData.bankAccessDataOrException(bankAccess.getId()).getBankAccounts();
        Iterator<BankAccount> accountIterator = bankAccounts.iterator();
        while (accountIterator.hasNext()) {
            BankAccount newAccount = accountIterator.next();
            userBankAccounts.stream().filter(bankAccountData -> {
                String newAccountExternalID = (String)newAccount.getExternalIdMap().get(onlineBankingService.bankApi());
                String existingAccountExternalID = (String)bankAccountData.getBankAccount().getExternalIdMap().get(onlineBankingService.bankApi());
                return newAccountExternalID.equals(existingAccountExternalID);
            }).findFirst().ifPresent(bankAccountEntity -> accountIterator.remove());
        }
        if (bankAccounts.size() == 0) {
            throw new BankAccessAlreadyExistException(bankAccess.getId());
        }
        bankAccess.setBankName(bankAccounts.get(0).getBankName());
    }
}

