/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.domain.BankAccessCredentials;
import de.adorsys.multibanking.domain.BankAccessData;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccountData;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.UserData;
import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.exception.BankAccessAlreadyExistException;
import de.adorsys.multibanking.exception.InvalidPinException;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.service.BankAccessCredentialService;
import de.adorsys.multibanking.service.BankAccountService;
import de.adorsys.multibanking.service.UserDataService;
import de.adorsys.multibanking.service.base.UserObjectService;
import de.adorsys.multibanking.service.producer.OnlineBankingServiceProducer;
import de.adorsys.multibanking.utils.FQNUtils;
import de.adorsys.multibanking.utils.Ids;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import spi.OnlineBankingService;

@Service
public class BankAccessService {
    @Autowired
    private UserObjectService uos;
    @Autowired
    private BankAccessCredentialService credentialService;
    @Autowired
    private UserDataService uds;
    @Autowired
    private OnlineBankingServiceProducer bankingServiceProducer;
    @Autowired
    private BankAccountService bankAccountService;

    public BankAccessEntity createBankAccess(BankAccessEntity bankAccess) {
        bankAccess.setUserId(this.uos.auth().getUserID().getValue());
        if (StringUtils.isBlank((CharSequence)bankAccess.getId())) {
            bankAccess.setId(Ids.uuid());
        } else if (this.exists(bankAccess.getId())) {
            throw new BankAccessAlreadyExistException(bankAccess.getId());
        }
        BankAccessCredentials credentials = bankAccess.cloneCredentials();
        bankAccess.cleanCredentials();
        if (bankAccess.isStorePin()) {
            this.credentialService.store(credentials);
        }
        this.storeBankAccess(bankAccess);
        try {
            this.bankAccountService.synchBankAccounts(bankAccess, credentials);
        }
        catch (InvalidPinException e) {
            if (bankAccess.isStorePin()) {
                this.credentialService.invalidate(credentials);
            }
            throw e;
        }
        return bankAccess;
    }

    public void updateBankAccess(BankAccessEntity bankAccessEntity) {
        this.storeBankAccess(bankAccessEntity);
    }

    public boolean deleteBankAccess(String accessId) {
        return this.deleteBankAccessInternal(accessId, this.uds.load());
    }

    public boolean exists(String accessId) {
        UserData userData = this.uds.load();
        return userData.containsKey(accessId);
    }

    private void storeBankAccess(BankAccessEntity bankAccess) {
        bankAccess.cleanCredentials();
        UserData userData = !this.uds.exists() ? this.uds.createUser(null) : this.uds.load();
        BankAccessData accessData = userData.getBankAccess(bankAccess.getId()).orElseGet(() -> {
            BankAccessData b = new BankAccessData();
            userData.put(bankAccess.getId(), b);
            return b;
        });
        accessData.setBankAccess(bankAccess);
        this.uds.store(userData);
    }

    private boolean deleteBankAccessInternal(String accessId, UserData userData) {
        BankAccessData accessData = userData.remove(accessId);
        if (accessData != null) {
            this.uds.store(userData);
            this.uos.flush();
            this.removeRemoteRegistrations(accessData, userData);
            this.uos.deleteDirectory(FQNUtils.bankAccessDirFQN(accessId));
            return true;
        }
        return false;
    }

    private void removeRemoteRegistrations(BankAccessData accessData, UserData userData) {
        List<BankAccountData> bankAccountDataList = accessData.getBankAccounts();
        UserEntity userEntity = userData.getUserEntity();
        bankAccountDataList.stream().forEach(bankAccountData -> {
            BankAccountEntity bankAccountEntity = bankAccountData.getBankAccount();
            bankAccountEntity.getExternalIdMap().keySet().forEach(bankApi -> {
                OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService((BankApi)bankApi);
                if (bankingService.userRegistrationRequired()) {
                    BankApiUser bankApiUser = userEntity.getApiUser().stream().filter(apiUser -> apiUser.getBankApi() == bankApi).findFirst().orElseThrow(() -> new ResourceNotFoundException(BankApiUser.class, bankApi.toString()));
                    bankingService.removeBankAccount((BankAccount)bankAccountEntity, bankApiUser);
                }
            });
        });
    }
}

