/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain;

import de.adorsys.multibanking.domain.AccountSynchPref;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccountData;
import de.adorsys.multibanking.domain.BankAccountEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BankAccessData {
    private BankAccessEntity bankAccess;
    private List<BankAccountData> bankAccounts = new ArrayList<BankAccountData>();
    private AccountSynchPref accountSynchPref;

    public Optional<BankAccountData> getBankAccount(String accountId) {
        for (BankAccountData bankAccountData : this.bankAccounts) {
            if (!bankAccountData.getBankAccount().getId().equals(accountId)) continue;
            return Optional.of(bankAccountData);
        }
        return Optional.empty();
    }

    public List<BankAccountEntity> bankAccountEntityAsList() {
        ArrayList<BankAccountEntity> result = new ArrayList<BankAccountEntity>();
        for (BankAccountData bankAccountData : this.bankAccounts) {
            result.add(bankAccountData.getBankAccount());
        }
        return result;
    }

    public boolean containsKey(String accountId) {
        for (BankAccountData bankAccountData : this.bankAccounts) {
            if (!bankAccountData.getBankAccount().getId().equals(accountId)) continue;
            return true;
        }
        return false;
    }

    public BankAccessEntity getBankAccess() {
        return this.bankAccess;
    }

    public List<BankAccountData> getBankAccounts() {
        return this.bankAccounts;
    }

    public AccountSynchPref getAccountSynchPref() {
        return this.accountSynchPref;
    }

    public void setBankAccess(BankAccessEntity bankAccess) {
        this.bankAccess = bankAccess;
    }

    public void setBankAccounts(List<BankAccountData> bankAccounts) {
        this.bankAccounts = bankAccounts;
    }

    public void setAccountSynchPref(AccountSynchPref accountSynchPref) {
        this.accountSynchPref = accountSynchPref;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankAccessData)) {
            return false;
        }
        BankAccessData other = (BankAccessData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BankAccessEntity this$bankAccess = this.getBankAccess();
        BankAccessEntity other$bankAccess = other.getBankAccess();
        if (this$bankAccess == null ? other$bankAccess != null : !((Object)this$bankAccess).equals(other$bankAccess)) {
            return false;
        }
        List<BankAccountData> this$bankAccounts = this.getBankAccounts();
        List<BankAccountData> other$bankAccounts = other.getBankAccounts();
        if (this$bankAccounts == null ? other$bankAccounts != null : !((Object)this$bankAccounts).equals(other$bankAccounts)) {
            return false;
        }
        AccountSynchPref this$accountSynchPref = this.getAccountSynchPref();
        AccountSynchPref other$accountSynchPref = other.getAccountSynchPref();
        return !(this$accountSynchPref == null ? other$accountSynchPref != null : !((Object)this$accountSynchPref).equals(other$accountSynchPref));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BankAccessData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BankAccessEntity $bankAccess = this.getBankAccess();
        result = result * 59 + ($bankAccess == null ? 43 : ((Object)$bankAccess).hashCode());
        List<BankAccountData> $bankAccounts = this.getBankAccounts();
        result = result * 59 + ($bankAccounts == null ? 43 : ((Object)$bankAccounts).hashCode());
        AccountSynchPref $accountSynchPref = this.getAccountSynchPref();
        result = result * 59 + ($accountSynchPref == null ? 43 : ((Object)$accountSynchPref).hashCode());
        return result;
    }

    public String toString() {
        return "BankAccessData(bankAccess=" + this.getBankAccess() + ", bankAccounts=" + this.getBankAccounts() + ", accountSynchPref=" + this.getAccountSynchPref() + ")";
    }
}

