/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.analytics.connector;

import de.adorsys.multibanking.analytics.connector.CreditorIdValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DECreditorIdValidator
implements CreditorIdValidator {
    private static final String PATTERN = "([deDE]{2}[0-9]{2,2}[A-Za-z0-9]{3,3}[0]{1}[0-9]{10})";
    private static final Pattern regEx = Pattern.compile("([deDE]{2}[0-9]{2,2}[A-Za-z0-9]{3,3}[0]{1}[0-9]{10})", 2);
    private static final int length = 18;

    @Override
    public String find(String text) {
        if (text == null || text.length() < 18) {
            return null;
        }
        Matcher matcher = regEx.matcher(text);
        if (matcher.find()) {
            return matcher.group(0).toUpperCase();
        }
        return null;
    }

    @Override
    public String nationalId(String creditorId) {
        return StringUtils.substring((String)creditorId, (int)7).toUpperCase();
    }

    @Override
    public boolean isValid(String creditorId) {
        if (creditorId == null) {
            return false;
        }
        if (creditorId.length() != 18) {
            return false;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)creditorId, (CharSequence)"de")) {
            return false;
        }
        if ("0".equals(Character.valueOf(creditorId.charAt(7)))) {
            return false;
        }
        return creditorId.matches(PATTERN);
    }
}

