/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.user;

import de.adorsys.multibanking.domain.UserData;
import de.adorsys.multibanking.exception.domain.MultibankingError;
import de.adorsys.multibanking.service.UserDataService;
import de.adorsys.multibanking.web.annotation.UserResource;
import de.adorsys.multibanking.web.common.BankAccessBasedController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@UserResource
@RestController
@RequestMapping(path={"/api/v1"})
@Api(value="/api/v1", tags={"MB-001 - User Data"}, description="Manages information associated with the user. The user data object contains all banking information collected with the exception of bookings.")
public class UserDataController
extends BankAccessBasedController {
    public static final String BASE_PATH = "/api/v1";
    @Autowired
    private UserDataService uds;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="Load user data", notes="Loads the user data, containing bank accesses (without credentials), bank accounts and account synchronization preferences.")
    @ApiResponses(value={@ApiResponse(code=200, message="Ok", response=UserData.class), @ApiResponse(code=401, message="user.unauthenticated : User not authenticated", response=MultibankingError.class), @ApiResponse(code=403, message="credential.invalid: Credentials not valid for provided bank code", response=MultibankingError.class), @ApiResponse(code=400, message="Invalid request. See response content.", response=MultibankingError.class)})
    @ResponseBody
    public ResponseEntity<ByteArrayResource> loadUserData() {
        return this.loadBytesForWeb(this.uds.loadDocument());
    }
}

