/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.common;

import de.adorsys.multibanking.domain.BankAccountData;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.service.BankAccountService;
import de.adorsys.multibanking.web.common.BankAccessBasedController;
import de.adorsys.multibanking.web.common.SynchChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BankAccountBasedController
extends BankAccessBasedController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BankAccountBasedController.class);
    @Autowired
    protected BankAccountService bankAccountService;

    protected void checkBankAccountExists(String accessId, String accountId) {
        this.checkBankAccessExists(accessId);
        if (!this.bankAccountService.exists(accessId, accountId)) {
            throw new ResourceNotFoundException(BankAccountEntity.class, accessId + ":" + accountId);
        }
    }

    protected void checkSynch(String accessId, String accountId) {
        BankAccountData accountData = this.bankAccountService.loadBankAccount(accessId, accountId);
        SynchChecker.checkSynch(accountData);
    }
}

