/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.analytics;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.domain.CustomRuleEntity;
import de.adorsys.multibanking.domain.RuleEntity;
import de.adorsys.multibanking.exception.InvalidRulesException;
import de.adorsys.multibanking.service.analytics.CustomBookingRuleService;
import de.adorsys.multibanking.service.analytics.SystemBookingRuleService;
import de.adorsys.multibanking.web.annotation.UserResource;
import de.adorsys.multibanking.web.common.BaseController;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@UserResource
@RestController
@RequestMapping(path={"/api/v1/analytics/rules"})
@Api(value="/api/v1/analytics/rules", tags={"MB-008 - Analytics"}, description="Manages account and booking analytics.")
public class BookingRuleController
extends BaseController {
    public static final String BASE_PATH = "/api/v1/analytics/rules";
    private static final Logger log = LoggerFactory.getLogger(BookingRuleController.class);
    private static final ObjectMapper YAML_OBJECT_MAPPER = BookingRuleController.yamlObjectMapper();
    @Autowired
    private CustomBookingRuleService customBookingRuleService;
    @Autowired
    private SystemBookingRuleService systemBookingRuleService;

    @RequestMapping(method={RequestMethod.POST})
    public HttpEntity<Void> createRule(@RequestBody CustomRuleEntity ruleEntity) {
        this.customBookingRuleService.createOrUpdateRule(ruleEntity);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @RequestMapping(value={"/custom"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ByteArrayResource> getCustomRules() {
        DSDocument dsDocument = this.customBookingRuleService.getBookingRules();
        return this.loadBytesForWeb(dsDocument);
    }

    @RequestMapping(value={"/static"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ByteArrayResource> getStaticRules() {
        DSDocument dsDocument = this.systemBookingRuleService.getBookingRules();
        return this.loadBytesForWeb(dsDocument);
    }

    @RequestMapping(value={"/custom/{ruleId}"}, method={RequestMethod.PUT})
    public HttpEntity<Void> updateCustomRule(@PathVariable String ruleId, @RequestBody CustomRuleEntity ruleEntity) {
        ruleEntity.setId(ruleId);
        this.customBookingRuleService.createOrUpdateRule(ruleEntity);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/static/{ruleId}"}, method={RequestMethod.PUT})
    public HttpEntity<Void> updateRule(@PathVariable String ruleId, @RequestBody RuleEntity ruleEntity) {
        ruleEntity.setId(ruleId);
        this.systemBookingRuleService.createOrUpdateRule(ruleEntity);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(path={"/custom"}, method={RequestMethod.PUT})
    public HttpEntity<Void> createOrUpdateCustomRules(@RequestBody List<CustomRuleEntity> ruleEntities) {
        this.customBookingRuleService.createOrUpdateRules(ruleEntities);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(path={"/static"}, method={RequestMethod.PUT})
    public HttpEntity<Void> createOrUpdateStaticRules(@RequestBody List<RuleEntity> ruleEntities) {
        this.systemBookingRuleService.createOrUpdateRules(ruleEntities);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(path={"/custom/upload"}, method={RequestMethod.PUT}, consumes={"application/octet-stream"})
    public HttpEntity<?> uploadReplaceCustomRules(@RequestParam MultipartFile rulesFile) {
        if (!rulesFile.isEmpty()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE).body((Object)"File is empty");
        }
        try {
            List rulesEntities = (List)YAML_OBJECT_MAPPER.readValue(rulesFile.getInputStream(), (TypeReference)new TypeReference<List<CustomRuleEntity>>(){});
            this.customBookingRuleService.replaceRules(rulesEntities);
            return new ResponseEntity(HttpStatus.CREATED);
        }
        catch (IOException e) {
            throw new InvalidRulesException(e.getMessage());
        }
    }

    @RequestMapping(path={"/static/upload"}, method={RequestMethod.PUT}, consumes={"application/octet-stream"})
    public HttpEntity<?> uploadReplaceStaticRules(@RequestParam MultipartFile rulesFile) {
        if (!rulesFile.isEmpty()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE).body((Object)"File is empty");
        }
        try {
            List rulesEntities = (List)YAML_OBJECT_MAPPER.readValue(rulesFile.getInputStream(), (TypeReference)new TypeReference<List<RuleEntity>>(){});
            this.systemBookingRuleService.replaceRules(rulesEntities);
            return new ResponseEntity(HttpStatus.CREATED);
        }
        catch (IOException e) {
            throw new InvalidRulesException(e.getMessage());
        }
    }

    @RequestMapping(value={"/custom/{ruleId}"}, method={RequestMethod.DELETE})
    public HttpEntity<Void> deleteCustomRule(@PathVariable String ruleId) {
        this.customBookingRuleService.deleteRule(ruleId);
        log.info("Rule [{}] deleted.", (Object)ruleId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/static/{ruleId}"}, method={RequestMethod.DELETE})
    public HttpEntity<Void> deleteStaticRule(@PathVariable String ruleId) {
        this.systemBookingRuleService.deleteRule(ruleId);
        log.info("Rule [{}] deleted.", (Object)ruleId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/custom"}, method={RequestMethod.DELETE})
    public HttpEntity<Void> deleteCustomRules(@PathVariable List<String> ruleIds) {
        this.customBookingRuleService.deleteRules(ruleIds);
        log.info("Rule [{}] deleted.", ruleIds);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/static"}, method={RequestMethod.DELETE})
    public HttpEntity<Void> deleteStaticRules(@PathVariable List<String> ruleIds) {
        this.systemBookingRuleService.deleteRules(ruleIds);
        log.info("Rule [{}] deleted.", ruleIds);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

