/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.crypto;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import de.adorsys.sts.keymanagement.service.DecryptionService;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class SecretClaimDecryptionService {
    private static final TypeReference<Map<String, String>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, String>>(){};
    private final String audience;
    private final String secretClaimPropertyKey;
    private final DecryptionService decryptionService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public SecretClaimDecryptionService(@Value(value="${sts.audience_name}") String audience, @Value(value="${sts.secret_claim_property_key}") String secretClaimPropertyKey, DecryptionService decryptionService) {
        this.audience = audience;
        this.secretClaimPropertyKey = secretClaimPropertyKey;
        this.decryptionService = decryptionService;
    }

    public String decryptSecretClaim() {
        Map<String, String> encryptedSecretClaims;
        try {
            encryptedSecretClaims = this.readSecretClaims();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String encryptedSecretClaim = encryptedSecretClaims.get(this.audience);
        if (StringUtils.isNotBlank((CharSequence)encryptedSecretClaim)) {
            return this.decryptionService.decrypt(encryptedSecretClaim);
        }
        return null;
    }

    private Map<String, String> readSecretClaims() throws IOException {
        JWTClaimsSet credentials = null;
        Object credentialsObject = SecurityContextHolder.getContext().getAuthentication().getCredentials();
        if (!(credentialsObject instanceof JWTClaimsSet)) {
            return Collections.emptyMap();
        }
        credentials = (JWTClaimsSet)credentialsObject;
        String secretClaim = (String)credentials.getClaim(this.secretClaimPropertyKey);
        return (Map)this.objectMapper.readValue(secretClaim, MAP_TYPE_REFERENCE);
    }
}

