/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.base;

import com.nimbusds.jose.jwk.JWK;
import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentStream;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.service.types.AccessType;
import org.apache.commons.lang3.StringUtils;

public class ExceptionHandlingDocumentSafeService
implements DocumentSafeService {
    private DocumentSafeService delegate;

    public ExceptionHandlingDocumentSafeService(DocumentSafeService delegate) {
        this.delegate = delegate;
    }

    public void createUser(UserIDAuth userIDAuth) {
        this.delegate.createUser(userIDAuth);
    }

    public void destroyUser(UserIDAuth userIDAuth) {
        this.delegate.destroyUser(userIDAuth);
    }

    public boolean userExists(UserID userID) {
        return this.delegate.userExists(userID);
    }

    public void storeDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        try {
            this.delegate.storeDocument(userIDAuth, dsDocument);
        }
        catch (BaseException b) {
            throw ExceptionHandlingDocumentSafeService.checkContainer(b, userIDAuth);
        }
    }

    public DSDocument readDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        try {
            return this.delegate.readDocument(userIDAuth, documentFQN);
        }
        catch (BaseException b) {
            throw ExceptionHandlingDocumentSafeService.checkContainer(b, userIDAuth);
        }
    }

    public void storeDocumentStream(UserIDAuth userIDAuth, DSDocumentStream dsDocumentStream) {
        try {
            this.delegate.storeDocumentStream(userIDAuth, dsDocumentStream);
        }
        catch (BaseException b) {
            throw ExceptionHandlingDocumentSafeService.checkContainer(b, userIDAuth);
        }
    }

    public DSDocumentStream readDocumentStream(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        try {
            return this.delegate.readDocumentStream(userIDAuth, documentFQN);
        }
        catch (BaseException b) {
            throw ExceptionHandlingDocumentSafeService.checkContainer(b, userIDAuth);
        }
    }

    public void deleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        try {
            this.delegate.deleteDocument(userIDAuth, documentFQN);
        }
        catch (BaseException b) {
            throw ExceptionHandlingDocumentSafeService.checkContainer(b, userIDAuth);
        }
    }

    public boolean documentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        try {
            return this.delegate.documentExists(userIDAuth, documentFQN);
        }
        catch (BaseException b) {
            throw ExceptionHandlingDocumentSafeService.checkContainer(b, userIDAuth);
        }
    }

    public void deleteFolder(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        try {
            this.delegate.deleteFolder(userIDAuth, documentDirectoryFQN);
        }
        catch (BaseException b) {
            throw ExceptionHandlingDocumentSafeService.checkContainer(b, userIDAuth);
        }
    }

    public void grantAccessToUserForFolder(UserIDAuth userIDAuth, UserID receiverUserID, DocumentDirectoryFQN documentDirectoryFQN, AccessType accessType) {
        try {
            this.delegate.grantAccessToUserForFolder(userIDAuth, receiverUserID, documentDirectoryFQN, accessType);
        }
        catch (BaseException b) {
            throw ExceptionHandlingDocumentSafeService.checkContainer(b, userIDAuth);
        }
    }

    public void storeGrantedDocument(UserIDAuth userIDAuth, UserID documentOwner, DSDocument dsDocument) {
        try {
            this.delegate.storeGrantedDocument(userIDAuth, documentOwner, dsDocument);
        }
        catch (BaseException b) {
            throw ExceptionHandlingDocumentSafeService.checkContainer(b, userIDAuth);
        }
    }

    public DSDocument readGrantedDocument(UserIDAuth userIDAuth, UserID documentOwner, DocumentFQN documentFQN) {
        try {
            return this.delegate.readGrantedDocument(userIDAuth, documentOwner, documentFQN);
        }
        catch (BaseException b) {
            throw ExceptionHandlingDocumentSafeService.checkContainer(b, userIDAuth);
        }
    }

    public JWK findPublicEncryptionKey(UserID userID) {
        try {
            return this.delegate.findPublicEncryptionKey(userID);
        }
        catch (BaseException b) {
            throw ExceptionHandlingDocumentSafeService.checkContainer(b, userID);
        }
    }

    private static boolean isContainerNotExist(BaseException b) {
        if (b instanceof org.adorsys.encobject.exceptions.ResourceNotFoundException) {
            return true;
        }
        String message = b.getMessage();
        return StringUtils.startsWith((CharSequence)message, (CharSequence)"Container") && StringUtils.endsWith((CharSequence)message, (CharSequence)"does not exist");
    }

    private static RuntimeException checkContainer(BaseException b, UserIDAuth userIDAuth) {
        return ExceptionHandlingDocumentSafeService.checkContainer(b, userIDAuth.getUserID());
    }

    private static RuntimeException checkContainer(BaseException b, UserID userID) {
        if (ExceptionHandlingDocumentSafeService.isContainerNotExist(b)) {
            return new ResourceNotFoundException(UserEntity.class, userID.getValue());
        }
        return b;
    }
}

