/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.base;

import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentBasedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentBasedService.class);

    protected abstract UserIDAuth auth();

    protected abstract DocumentSafeService docs();

    public boolean documentExists(DocumentFQN documentFQN) {
        return this.docs().documentExists(this.auth(), documentFQN);
    }

    public DSDocument loadDocument(DocumentFQN documentFQN) {
        LOGGER.debug("loadDocument " + documentFQN);
        return this.docs().readDocument(this.auth(), documentFQN);
    }

    public void storeDocument(DSDocument dsDocument) {
        this.docs().storeDocument(this.auth(), dsDocument);
    }

    public void storeDocument(DocumentFQN documentFQN, byte[] data) {
        LOGGER.debug("storeDocument " + documentFQN);
        DocumentContent documentContent = new DocumentContent(data);
        DSDocument dsDocument = new DSDocument(documentFQN, documentContent, null);
        this.docs().storeDocument(this.auth(), dsDocument);
    }

    public void deleteDirectory(DocumentDirectoryFQN dirFQN) {
        this.docs().deleteFolder(this.auth(), dirFQN);
    }

    public void deleteDocument(DocumentFQN documentFQN) {
        LOGGER.debug("deleteDocument " + documentFQN);
        this.docs().deleteDocument(this.auth(), documentFQN);
    }
}

