/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.exception.domain;

import de.adorsys.multibanking.exception.domain.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Messages
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String uuid;
    private Collection<Message> messages;

    public static Messages createError(String key) {
        return Messages.builder().message(new Message(key, Message.Severity.ERROR)).build();
    }

    public static Messages createError(String key, String renderedMessage) {
        return Messages.builder().message(new Message(key, Message.Severity.ERROR, renderedMessage)).build();
    }

    public static Messages createError(String key, String renderedMessage, Map<String, String> params) {
        return Messages.builder().message(new Message(key, Message.Severity.ERROR, renderedMessage, params)).build();
    }

    public static MessagesBuilder builder() {
        return new MessagesBuilder();
    }

    public String getUuid() {
        return this.uuid;
    }

    public Collection<Message> getMessages() {
        return this.messages;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setMessages(Collection<Message> messages) {
        this.messages = messages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Messages)) {
            return false;
        }
        Messages other = (Messages)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        Collection<Message> this$messages = this.getMessages();
        Collection<Message> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Messages;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        Collection<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }

    public String toString() {
        return "Messages(uuid=" + this.getUuid() + ", messages=" + this.getMessages() + ")";
    }

    public Messages() {
    }

    public Messages(String uuid, Collection<Message> messages) {
        this.uuid = uuid;
        this.messages = messages;
    }

    public static class MessagesBuilder {
        private String uuid;
        private ArrayList<Message> messages;

        MessagesBuilder() {
        }

        public MessagesBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public MessagesBuilder message(Message message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return this;
        }

        public MessagesBuilder messages(Collection<? extends Message> messages) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return this;
        }

        public MessagesBuilder clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return this;
        }

        public Messages build() {
            List<Message> messages;
            switch (this.messages == null ? 0 : this.messages.size()) {
                case 0: {
                    messages = Collections.emptyList();
                    break;
                }
                case 1: {
                    messages = Collections.singletonList(this.messages.get(0));
                    break;
                }
                default: {
                    messages = Collections.unmodifiableList(new ArrayList<Message>(this.messages));
                }
            }
            return new Messages(this.uuid, messages);
        }

        public String toString() {
            return "Messages.MessagesBuilder(uuid=" + this.uuid + ", messages=" + this.messages + ")";
        }
    }
}

