/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain;

import de.adorsys.multibanking.domain.AccountSynchPref;
import de.adorsys.multibanking.domain.BankAccessData;
import de.adorsys.multibanking.domain.BankAccountData;
import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class UserData {
    private UserEntity userEntity;
    private List<BankAccessData> bankAccesses = new ArrayList<BankAccessData>();
    private AccountSynchPref accountSynchPref;

    public Optional<BankAccessData> getBankAccess(String accessId) {
        return this.bankAccesses.stream().filter(b -> StringUtils.equals((CharSequence)accessId, (CharSequence)b.getBankAccess().getId())).findFirst();
    }

    public BankAccessData bankAccessDataOrException(String accessId) {
        return this.getBankAccess(accessId).orElseThrow(() -> new ResourceNotFoundException(BankAccessData.class, accessId));
    }

    public BankAccountData bankAccountDataOrException(String accessId, String accountId) {
        return this.bankAccessDataOrException(accessId).getBankAccount(accountId).orElseThrow(() -> new ResourceNotFoundException(BankAccountData.class, accessId));
    }

    public BankAccessData remove(String accessId) {
        List candidates = this.bankAccesses.stream().filter(b -> StringUtils.equals((CharSequence)accessId, (CharSequence)b.getBankAccess().getId())).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            return null;
        }
        this.bankAccesses.removeAll(candidates);
        return (BankAccessData)candidates.iterator().next();
    }

    public boolean containsKey(String accessId) {
        return this.getBankAccess(accessId).isPresent();
    }

    public void put(String id, BankAccessData b) {
        this.remove(id);
        this.bankAccesses.add(b);
    }

    public BankAccessData get(String accessId) {
        return this.getBankAccess(accessId).orElse(null);
    }

    public UserEntity getUserEntity() {
        return this.userEntity;
    }

    public List<BankAccessData> getBankAccesses() {
        return this.bankAccesses;
    }

    public AccountSynchPref getAccountSynchPref() {
        return this.accountSynchPref;
    }

    public void setUserEntity(UserEntity userEntity) {
        this.userEntity = userEntity;
    }

    public void setBankAccesses(List<BankAccessData> bankAccesses) {
        this.bankAccesses = bankAccesses;
    }

    public void setAccountSynchPref(AccountSynchPref accountSynchPref) {
        this.accountSynchPref = accountSynchPref;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserData)) {
            return false;
        }
        UserData other = (UserData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UserEntity this$userEntity = this.getUserEntity();
        UserEntity other$userEntity = other.getUserEntity();
        if (this$userEntity == null ? other$userEntity != null : !((Object)this$userEntity).equals(other$userEntity)) {
            return false;
        }
        List<BankAccessData> this$bankAccesses = this.getBankAccesses();
        List<BankAccessData> other$bankAccesses = other.getBankAccesses();
        if (this$bankAccesses == null ? other$bankAccesses != null : !((Object)this$bankAccesses).equals(other$bankAccesses)) {
            return false;
        }
        AccountSynchPref this$accountSynchPref = this.getAccountSynchPref();
        AccountSynchPref other$accountSynchPref = other.getAccountSynchPref();
        return !(this$accountSynchPref == null ? other$accountSynchPref != null : !((Object)this$accountSynchPref).equals(other$accountSynchPref));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserEntity $userEntity = this.getUserEntity();
        result = result * 59 + ($userEntity == null ? 43 : ((Object)$userEntity).hashCode());
        List<BankAccessData> $bankAccesses = this.getBankAccesses();
        result = result * 59 + ($bankAccesses == null ? 43 : ((Object)$bankAccesses).hashCode());
        AccountSynchPref $accountSynchPref = this.getAccountSynchPref();
        result = result * 59 + ($accountSynchPref == null ? 43 : ((Object)$accountSynchPref).hashCode());
        return result;
    }

    public String toString() {
        return "UserData(userEntity=" + this.getUserEntity() + ", bankAccesses=" + this.getBankAccesses() + ", accountSynchPref=" + this.getAccountSynchPref() + ")";
    }
}

