/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import de.adorsys.multibanking.domain.AccountAnalyticsEntity;
import de.adorsys.multibanking.domain.AccountSynchPref;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BookingFile;
import de.adorsys.multibanking.domain.ContractEntity;
import de.adorsys.multibanking.domain.StandingOrderEntity;
import domain.BankAccount;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BankAccountData {
    private BankAccountEntity bankAccount;
    private List<BookingFile> bookingFiles = new ArrayList<BookingFile>();
    private AccountSynchPref accountSynchPref;
    private Map<String, StandingOrderEntity> standingOrders;
    private List<ContractEntity> contracts = new ArrayList<ContractEntity>();
    private AccountAnalyticsEntity analytic;
    @ApiModelProperty(value="Time of last Synchronisation status", example="2017-12-01T12:25:44")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime syncStatusTime;

    public void update(Collection<BookingFile> newEntries) {
        this.bookingFiles.addAll(newEntries);
    }

    public void updateSyncStatus(BankAccount.SyncStatus syncStatus) {
        LocalDateTime now = LocalDateTime.now();
        this.bankAccount.setSyncStatus(syncStatus);
        this.syncStatusTime = now;
        if (BankAccount.SyncStatus.READY == syncStatus) {
            this.bankAccount.setLastSync(now);
        }
    }

    public Boolean containsBookingFileOfPeriod(String period) {
        return this.bookingFiles.stream().filter(bookingFile -> period.equals(bookingFile.getPeriod())).count() > 0L;
    }

    public Optional<BookingFile> findBookingFileOfPeriod(String period) {
        return this.bookingFiles.stream().filter(bookingFile -> period.equals(bookingFile.getPeriod())).findFirst();
    }

    public BankAccountEntity getBankAccount() {
        return this.bankAccount;
    }

    public List<BookingFile> getBookingFiles() {
        return this.bookingFiles;
    }

    public AccountSynchPref getAccountSynchPref() {
        return this.accountSynchPref;
    }

    public Map<String, StandingOrderEntity> getStandingOrders() {
        return this.standingOrders;
    }

    public List<ContractEntity> getContracts() {
        return this.contracts;
    }

    public AccountAnalyticsEntity getAnalytic() {
        return this.analytic;
    }

    public LocalDateTime getSyncStatusTime() {
        return this.syncStatusTime;
    }

    public void setBankAccount(BankAccountEntity bankAccount) {
        this.bankAccount = bankAccount;
    }

    public void setBookingFiles(List<BookingFile> bookingFiles) {
        this.bookingFiles = bookingFiles;
    }

    public void setAccountSynchPref(AccountSynchPref accountSynchPref) {
        this.accountSynchPref = accountSynchPref;
    }

    public void setStandingOrders(Map<String, StandingOrderEntity> standingOrders) {
        this.standingOrders = standingOrders;
    }

    public void setContracts(List<ContractEntity> contracts) {
        this.contracts = contracts;
    }

    public void setAnalytic(AccountAnalyticsEntity analytic) {
        this.analytic = analytic;
    }

    public void setSyncStatusTime(LocalDateTime syncStatusTime) {
        this.syncStatusTime = syncStatusTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankAccountData)) {
            return false;
        }
        BankAccountData other = (BankAccountData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BankAccountEntity this$bankAccount = this.getBankAccount();
        BankAccountEntity other$bankAccount = other.getBankAccount();
        if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
            return false;
        }
        List<BookingFile> this$bookingFiles = this.getBookingFiles();
        List<BookingFile> other$bookingFiles = other.getBookingFiles();
        if (this$bookingFiles == null ? other$bookingFiles != null : !((Object)this$bookingFiles).equals(other$bookingFiles)) {
            return false;
        }
        AccountSynchPref this$accountSynchPref = this.getAccountSynchPref();
        AccountSynchPref other$accountSynchPref = other.getAccountSynchPref();
        if (this$accountSynchPref == null ? other$accountSynchPref != null : !((Object)this$accountSynchPref).equals(other$accountSynchPref)) {
            return false;
        }
        Map<String, StandingOrderEntity> this$standingOrders = this.getStandingOrders();
        Map<String, StandingOrderEntity> other$standingOrders = other.getStandingOrders();
        if (this$standingOrders == null ? other$standingOrders != null : !((Object)this$standingOrders).equals(other$standingOrders)) {
            return false;
        }
        List<ContractEntity> this$contracts = this.getContracts();
        List<ContractEntity> other$contracts = other.getContracts();
        if (this$contracts == null ? other$contracts != null : !((Object)this$contracts).equals(other$contracts)) {
            return false;
        }
        AccountAnalyticsEntity this$analytic = this.getAnalytic();
        AccountAnalyticsEntity other$analytic = other.getAnalytic();
        if (this$analytic == null ? other$analytic != null : !((Object)this$analytic).equals(other$analytic)) {
            return false;
        }
        LocalDateTime this$syncStatusTime = this.getSyncStatusTime();
        LocalDateTime other$syncStatusTime = other.getSyncStatusTime();
        return !(this$syncStatusTime == null ? other$syncStatusTime != null : !((Object)this$syncStatusTime).equals(other$syncStatusTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BankAccountData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BankAccountEntity $bankAccount = this.getBankAccount();
        result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
        List<BookingFile> $bookingFiles = this.getBookingFiles();
        result = result * 59 + ($bookingFiles == null ? 43 : ((Object)$bookingFiles).hashCode());
        AccountSynchPref $accountSynchPref = this.getAccountSynchPref();
        result = result * 59 + ($accountSynchPref == null ? 43 : ((Object)$accountSynchPref).hashCode());
        Map<String, StandingOrderEntity> $standingOrders = this.getStandingOrders();
        result = result * 59 + ($standingOrders == null ? 43 : ((Object)$standingOrders).hashCode());
        List<ContractEntity> $contracts = this.getContracts();
        result = result * 59 + ($contracts == null ? 43 : ((Object)$contracts).hashCode());
        AccountAnalyticsEntity $analytic = this.getAnalytic();
        result = result * 59 + ($analytic == null ? 43 : ((Object)$analytic).hashCode());
        LocalDateTime $syncStatusTime = this.getSyncStatusTime();
        result = result * 59 + ($syncStatusTime == null ? 43 : ((Object)$syncStatusTime).hashCode());
        return result;
    }

    public String toString() {
        return "BankAccountData(bankAccount=" + this.getBankAccount() + ", bookingFiles=" + this.getBookingFiles() + ", accountSynchPref=" + this.getAccountSynchPref() + ", standingOrders=" + this.getStandingOrders() + ", contracts=" + this.getContracts() + ", analytic=" + this.getAnalytic() + ", syncStatusTime=" + this.getSyncStatusTime() + ")";
    }
}

