/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.auth;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.multibanking.auth.CacheEntry;
import de.adorsys.multibanking.auth.UserContext;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserContextCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserContextCache.class);
    private UserContext userContext;

    public UserContextCache(UserContext userContext) {
        this.userContext = userContext;
    }

    public <T> Optional<CacheEntry<T>> cacheHit(DocumentFQN documentFQN, TypeReference<T> valueType) {
        if (!this.userContext.isCacheEnabled()) {
            return Optional.empty();
        }
        Map<DocumentFQN, CacheEntry<?>> typeCache = this.typeCache(valueType);
        CacheEntry<?> cacheEntry = typeCache.get(documentFQN);
        return Optional.ofNullable(cacheEntry);
    }

    public <T> boolean isCached(DocumentFQN documentFQN, TypeReference<T> valueType) {
        return this.entry(documentFQN, valueType).isPresent();
    }

    public <T> boolean isDirty(DocumentFQN documentFQN, TypeReference<T> cachedobjecttyperef) {
        Optional<CacheEntry<T>> entry = this.entry(documentFQN, cachedobjecttyperef);
        if (entry.isPresent()) {
            return entry.get().isDirty();
        }
        return false;
    }

    private <T> Optional<CacheEntry<T>> entry(DocumentFQN documentFQN, TypeReference<T> valueType) {
        if (!this.userContext.isCacheEnabled() || valueType == null) {
            return Optional.empty();
        }
        Map<DocumentFQN, CacheEntry<?>> typeCache = this.typeCache(valueType);
        return Optional.ofNullable(typeCache.get(documentFQN));
    }

    public <T> Optional<CacheEntry<T>> remove(DocumentFQN documentFQN, TypeReference<T> valueType) {
        if (!this.userContext.isCacheEnabled() || valueType == null) {
            return Optional.empty();
        }
        Map<DocumentFQN, CacheEntry<?>> typeCache = this.typeCache(valueType);
        if (typeCache.containsKey(documentFQN)) {
            return Optional.ofNullable(typeCache.remove(documentFQN));
        }
        return Optional.empty();
    }

    public <T> boolean cacheHit(DocumentFQN documentFQN, TypeReference<T> valueType, Optional<T> entry, boolean dirty) {
        if (!this.userContext.isCacheEnabled()) {
            return false;
        }
        Map<DocumentFQN, CacheEntry<?>> typeCache = this.typeCache(valueType);
        CacheEntry<T> cacheEntry = new CacheEntry<T>();
        cacheEntry.setDocFqn(documentFQN);
        cacheEntry.setEntry(entry);
        cacheEntry.setValueType(valueType);
        cacheEntry.setDirty(dirty);
        typeCache.put(documentFQN, cacheEntry);
        return true;
    }

    private <T> Map<DocumentFQN, CacheEntry<?>> typeCache(TypeReference<T> valueType) {
        Map<DocumentFQN, CacheEntry<?>> map = this.userContext.getCache().get(valueType.getType());
        if (map == null) {
            map = new HashMap();
            this.userContext.getCache().put(valueType.getType(), map);
        }
        return map;
    }

    public void clearCached(DocumentDirectoryFQN dir) {
        LOGGER.debug("Clearing cache for " + dir);
        Map<Type, Map<DocumentFQN, CacheEntry<?>>> cache = this.userContext.getCache();
        Collection<Map<DocumentFQN, CacheEntry<?>>> values = cache.values();
        String path = dir.getValue();
        for (Map<DocumentFQN, CacheEntry<?>> map : values) {
            Set<Map.Entry<DocumentFQN, CacheEntry<?>>> entrySet = map.entrySet();
            HashSet<DocumentFQN> keyToRemove = new HashSet<DocumentFQN>();
            for (Map.Entry<DocumentFQN, CacheEntry<?>> entry : entrySet) {
                DocumentFQN documentFQN = entry.getKey();
                if (!StringUtils.startsWith((CharSequence)documentFQN.getValue(), (CharSequence)path) || entry.getValue() != null && entry.getValue().isDirty()) continue;
                keyToRemove.add(documentFQN);
            }
            for (DocumentFQN documentFQN : keyToRemove) {
                LOGGER.debug("Removing from cache Cache " + documentFQN);
                map.remove(documentFQN);
            }
        }
    }
}

