/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.common;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.adorsys.multibanking.auth.UserContext;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.web.user.UserDataController;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

public abstract class BaseController {
    public static final String BASE_PATH = "/api/v1";
    @Autowired
    private UserContext user;

    protected String userId() {
        return this.user.getAuth().getUserID().getValue();
    }

    protected ResponseEntity<ByteArrayResource> loadBytesForWeb(DSDocument dsDocument) {
        byte[] data = dsDocument.getDocumentContent().getValue();
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON_UTF8).contentLength((long)data.length).body((Object)new ByteArrayResource(data));
    }

    protected ResponseEntity<ByteArrayResource> loadBytesForWeb(DSDocument dsDocument, MediaType mediaType) {
        byte[] data = dsDocument.getDocumentContent().getValue();
        return ResponseEntity.ok().contentType(mediaType).contentLength((long)data.length).body((Object)new ByteArrayResource(data));
    }

    protected <T> ResponseEntity<T> returnDocument(T dsObjet) {
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body(dsObjet);
    }

    protected <T> ResponseEntity<T> returnDocument(T dsObjet, MediaType mediaType) {
        return ResponseEntity.ok().contentType(mediaType).body(dsObjet);
    }

    protected ResourceNotFoundException resourceNotFound(Class<?> klass, String id) {
        return new ResourceNotFoundException(klass, id);
    }

    protected static ObjectMapper yamlObjectMapper() {
        YAMLFactory ymlFactory = new YAMLFactory();
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)ymlFactory);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    protected HttpHeaders userDataLocationHeader() {
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(ControllerLinkBuilder.linkTo(((UserDataController)ControllerLinkBuilder.methodOn(UserDataController.class, (Object[])new Object[0])).loadUserData()).toUri());
        return headers;
    }
}

