/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.banks;

import de.adorsys.multibanking.exception.domain.MultibankingError;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.web.annotation.UserResource;
import de.adorsys.multibanking.web.common.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@UserResource
@RestController
@RequestMapping(path={"/api/v1/bank"})
@Api(value="/api/v1/bank", tags={"MB-003 - Banks"}, description="Loads the list of banks supported by this application. Clients might user this to offer search.")
public class BankController
extends BaseController {
    public static final String BASE_PATH = "/api/v1/bank";
    @Autowired
    BankService bankService;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="Loads and returns the list of supported banks.")
    @ApiResponses(value={@ApiResponse(code=200, message="Ok"), @ApiResponse(code=401, message="user.unauthenticated : User not authenticated", response=MultibankingError.class), @ApiResponse(code=412, message="User with Id [{1}] not found. First create the user.", response=MultibankingError.class), @ApiResponse(code=400, message="Invalid request. See response content.", response=MultibankingError.class)})
    public ResponseEntity<ByteArrayResource> loadBanks() {
        return this.loadBytesForWeb(this.bankService.loadDocument(), MediaType.APPLICATION_JSON_UTF8);
    }
}

