/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.analytics;

import de.adorsys.multibanking.service.analytics.CustomImageService;
import de.adorsys.multibanking.service.analytics.SystemImageService;
import de.adorsys.multibanking.web.annotation.UserResource;
import de.adorsys.multibanking.web.common.BaseController;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.InputStream;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@UserResource
@RestController
@RequestMapping(path={"/api/v1/image"})
@Api(value="/api/v1/image", tags={"MB-008 - Analytics"}, description="Manages account and booking analytics.")
public class ImageController
extends BaseController {
    public static final String BASE_PATH = "/api/v1/image";
    @Autowired
    private CustomImageService customImageService;
    @Autowired
    private SystemImageService systemImageService;

    @GetMapping(value={"/{imageName}"}, produces={"image/png"})
    @ResponseBody
    public ResponseEntity<ByteArrayResource> getImage(@PathVariable String imageName) throws IOException {
        if (this.customImageService.hasImage(imageName)) {
            return this.loadBytesForWeb(this.customImageService.loadUserImage(imageName), MediaType.IMAGE_PNG);
        }
        return this.loadBytesForWeb(this.systemImageService.loadStaticImage(imageName), MediaType.IMAGE_PNG);
    }

    @RequestMapping(path={"/{imageName}"}, method={RequestMethod.PUT}, consumes={"image/png"})
    public HttpEntity<?> putImage(@PathVariable String imageName, @RequestParam MultipartFile imageFile) {
        if (!imageFile.isEmpty()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE).body((Object)"File is empty");
        }
        try {
            this.customImageService.storeUserImage(imageName, IOUtils.toByteArray((InputStream)imageFile.getInputStream()));
        }
        catch (IOException e) {
            throw new BaseException((Throwable)e);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(path={"/{imageName}/release"}, method={RequestMethod.POST})
    public HttpEntity<?> patchImage(@PathVariable String imageName) {
        DSDocument loadUserImage = this.customImageService.loadUserImage(imageName);
        this.systemImageService.storeStaticImage(imageName, loadUserImage.getDocumentContent().getValue());
        return new ResponseEntity(HttpStatus.OK);
    }
}

