/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.utils;

import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;

public class FQNUtils {
    public static final DocumentFQN banksFQN() {
        return new DocumentFQN("banks");
    }

    public static final DocumentFQN userDataFQN() {
        return new DocumentFQN("mbsUserData.aes");
    }

    private static final DocumentDirectoryFQN userAgentsDirFQN() {
        return new DocumentDirectoryFQN("userAgents");
    }

    private static final DocumentDirectoryFQN userAgentDirFQN(String userAgentId) {
        return FQNUtils.userAgentsDirFQN().addDirectory(userAgentId);
    }

    public static final DocumentFQN userAgentCredentialFQN(String userAgentId) {
        return FQNUtils.userAgentDirFQN(userAgentId).addName("credentials.aes");
    }

    private static final DocumentDirectoryFQN bankAccessesDirFQN() {
        return new DocumentDirectoryFQN("bankaccesses");
    }

    public static final DocumentDirectoryFQN bankAccessDirFQN(String bankAccessId) {
        return FQNUtils.bankAccessesDirFQN().addDirectory(bankAccessId);
    }

    public static final DocumentFQN credentialFQN(String bankAccessId) {
        return FQNUtils.bankAccessDirFQN(bankAccessId).addName("credentials.aes");
    }

    public static final DocumentDirectoryFQN bankAccountsDirFQN(String bankAccessId) {
        return FQNUtils.bankAccessDirFQN(bankAccessId).addDirectory("accounts");
    }

    private static final DocumentDirectoryFQN bankAccountDirFQN(String bankAccessId, String accountId) {
        return FQNUtils.bankAccountsDirFQN(bankAccessId).addDirectory(accountId);
    }

    private static final DocumentDirectoryFQN bankAccountPeriodFQN(String bankAccessId, String accountId, String period) {
        return FQNUtils.bankAccountDirFQN(bankAccessId, accountId).addDirectory(period);
    }

    public static DocumentFQN bookingFQN(String accessId, String accountId, String period) {
        return FQNUtils.bankAccountPeriodFQN(accessId, accountId, period).addName("bookings.aes");
    }

    public static DocumentFQN bookingRulesFQN() {
        return new DocumentFQN("bookingRules.aes");
    }

    public static DocumentFQN bookingCategoriesFQN() {
        return new DocumentFQN("bookingCategories.aes");
    }

    private static final DocumentDirectoryFQN imagesDirFQN() {
        return new DocumentDirectoryFQN("images");
    }

    public static DocumentFQN imageFQN(String imageName) {
        return FQNUtils.imagesDirFQN().addName(imageName);
    }

    public static DocumentFQN paymentsFQN(String accessId, String accountId) {
        return FQNUtils.bankAccountDirFQN(accessId, accountId).addName("payments.aes");
    }

    public static DocumentFQN anonymizedBookingFQN(String accessId, String accountId, String period) {
        return FQNUtils.bankAccountPeriodFQN(accessId, accountId, period).addName("anonymizedBookings.aes");
    }

    public static DocumentDirectoryFQN expireDirFQN() {
        return new DocumentDirectoryFQN("users").addDirectory("expiry");
    }

    public static DocumentFQN expireDayFileFQN(String dayDirName) {
        return FQNUtils.expireDirFQN().addName(dayDirName);
    }
}

