/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.helper;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.multibanking.domain.CategoryEntity;
import de.adorsys.multibanking.service.base.CacheBasedService;
import de.adorsys.multibanking.service.base.ListUtils;
import de.adorsys.multibanking.service.helper.CategoryUtils;
import java.util.Collections;
import java.util.List;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BookingCategoryServiceTemplate<T extends CategoryEntity> {
    @Autowired
    private DocumentSafeService documentSafeService;

    protected abstract CacheBasedService cbs();

    protected abstract TypeReference<List<T>> listType();

    public DSDocument getBookingCategories() {
        return this.documentSafeService.readDocument(this.cbs().auth(), CategoryUtils.bookingCategoriesFQN);
    }

    public void createOrUpdateCategory(T categoryEntity) {
        this.createOrUpdateCategories(Collections.singletonList(categoryEntity));
    }

    public void createOrUpdateCategories(List<T> categoryEntities) {
        List persList = this.cbs().load(CategoryUtils.bookingCategoriesFQN, this.listType()).orElse(Collections.emptyList());
        persList = ListUtils.updateList(categoryEntities, persList);
        this.cbs().store(CategoryUtils.bookingCategoriesFQN, this.listType(), persList);
    }

    public void replceCategories(List<T> categoryEntities) {
        categoryEntities = ListUtils.setId(categoryEntities);
        this.cbs().store(CategoryUtils.bookingCategoriesFQN, this.listType(), categoryEntities);
    }

    public boolean deleteCategory(String categoryId) {
        return this.deleteCategories(Collections.singletonList(categoryId));
    }

    public boolean deleteCategories(List<String> categoryIds) {
        List persList = this.cbs().load(CategoryUtils.bookingCategoriesFQN, this.listType()).orElse(Collections.emptyList());
        List newPersList = ListUtils.deleteListById(categoryIds, persList);
        this.cbs().store(CategoryUtils.bookingCategoriesFQN, this.listType(), newPersList);
        return newPersList.size() - persList.size() != 0;
    }
}

