/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.analytics;

import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.domain.BookingGroup;
import de.adorsys.multibanking.domain.BookingPeriod;
import de.adorsys.multibanking.domain.ContractEntity;
import de.adorsys.smartanalytics.api.AnalyticsResult;
import de.adorsys.smartanalytics.api.Booking;
import de.adorsys.smartanalytics.api.BookingGroup;
import de.adorsys.smartanalytics.api.Group;
import de.adorsys.smartanalytics.api.WrappedBooking;
import domain.BookingCategory;
import domain.Contract;
import domain.Cycle;
import domain.RuleCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class SmartanalyticsMapper {
    static List<Booking> convertInput(Collection<BookingEntity> bookings) {
        ArrayList<Booking> interfaceBookings = new ArrayList<Booking>();
        for (BookingEntity booking : bookings) {
            Booking smartanalyticsBooking = new Booking();
            smartanalyticsBooking.setBookingId(booking.getExternalId());
            smartanalyticsBooking.setCreditorId(booking.getCreditorId());
            smartanalyticsBooking.setPurpose(booking.getUsage());
            smartanalyticsBooking.setIban(booking.getOtherAccount() != null ? booking.getOtherAccount().getIban() : null);
            smartanalyticsBooking.setAccountNumber(booking.getOtherAccount() != null ? booking.getOtherAccount().getAccountNumber() : null);
            smartanalyticsBooking.setBankCode(booking.getOtherAccount() != null ? booking.getOtherAccount().getBlz() : null);
            smartanalyticsBooking.setAmount(booking.getAmount());
            smartanalyticsBooking.setExecutionDate(booking.getValutaDate());
            smartanalyticsBooking.setStandingOrder(booking.isStandingOrder());
            smartanalyticsBooking.setMandateReference(booking.getMandateReference());
            if (booking.getOtherAccount() != null) {
                if (booking.getOtherAccount().getOwner() != null) {
                    smartanalyticsBooking.setReferenceName(booking.getOtherAccount().getOwner());
                } else {
                    smartanalyticsBooking.setReferenceName(booking.getOtherAccount().getName());
                }
            }
            interfaceBookings.add(smartanalyticsBooking);
        }
        return interfaceBookings;
    }

    public static void applyCategories(List<BookingEntity> bookingEntities, AnalyticsResult result, List<RuleCategory> categories) {
        result.getBookings().forEach(categorizedBooking -> bookingEntities.stream().filter(bookingEntity -> categorizedBooking.getBooking().getBookingId().equals(bookingEntity.getExternalId())).findFirst().ifPresent(bookingEntity -> {
            if (StringUtils.isNotBlank((CharSequence)categorizedBooking.getOtherAccount()) && bookingEntity.getOtherAccount() != null) {
                bookingEntity.getOtherAccount().setOwner(categorizedBooking.getOtherAccount());
            }
            if (categorizedBooking.getMainCategory() != null) {
                bookingEntity.setBookingCategory(SmartanalyticsMapper.mapToBookingcategory(categorizedBooking, categories));
            }
        }));
    }

    static BookingCategory mapToBookingcategory(WrappedBooking extendedBooking, List<RuleCategory> categories) {
        return BookingCategory.builder().mainCategory(extendedBooking.getMainCategory()).subCategory(extendedBooking.getSubCategory()).specification(extendedBooking.getSpecification()).rules(extendedBooking.getRuleIds()).build();
    }

    static ContractEntity toContract(String userId, String accountId, BookingGroup bookingGroup) {
        ContractEntity contractEntity = new ContractEntity();
        contractEntity.setAmount(bookingGroup.getAmount());
        contractEntity.setInterval(Cycle.valueOf((String)bookingGroup.getCycle().toString()));
        contractEntity.setUserId(userId);
        contractEntity.setAccountId(accountId);
        contractEntity.setEmail(bookingGroup.getEmail());
        contractEntity.setHomepage(bookingGroup.getHomepage());
        contractEntity.setHotline(bookingGroup.getHotline());
        contractEntity.setLogo(bookingGroup.getLogo());
        contractEntity.setMainCategory(bookingGroup.getMainCategory());
        contractEntity.setSubCategory(bookingGroup.getSubCategory());
        contractEntity.setSpecification(bookingGroup.getSpecification());
        contractEntity.setProvider(bookingGroup.getOtherAccount());
        contractEntity.setMandateReference(bookingGroup.getMandatreference());
        return contractEntity;
    }

    static List<de.adorsys.multibanking.domain.BookingGroup> mapBookingGroups(List<BookingGroup> bookingGroups) {
        return bookingGroups.stream().map(bookingGroup -> SmartanalyticsMapper.toBookingGroup(bookingGroup)).collect(Collectors.toList());
    }

    static de.adorsys.multibanking.domain.BookingGroup toBookingGroup(BookingGroup bookingsGroup) {
        de.adorsys.multibanking.domain.BookingGroup bookingGroup = de.adorsys.multibanking.domain.BookingGroup.builder().amount(bookingsGroup.getAmount()).mainCategory(bookingsGroup.getMainCategory()).subCategory(bookingsGroup.getSubCategory()).specification(bookingsGroup.getSpecification()).bookingPeriods(SmartanalyticsMapper.mapBookingPeriods(bookingsGroup.getBookingPeriods())).type(BookingGroup.Type.valueOf(bookingsGroup.getGroupType().toString())).contract(Contract.builder().email(bookingsGroup.getEmail()).homepage(bookingsGroup.getHomepage()).logo(bookingsGroup.getLogo()).mandateReference(bookingsGroup.getMandatreference()).hotline(bookingsGroup.getHotline()).email(bookingsGroup.getEmail()).interval(bookingsGroup.getCycle() != null ? Cycle.valueOf((String)bookingsGroup.getCycle().name()) : null).build()).build();
        if (bookingsGroup.getGroupType() == Group.Type.CUSTOM || bookingsGroup.getGroupType() == Group.Type.OTHER_INCOME || bookingsGroup.getGroupType() == Group.Type.OTHER_EXPENSES) {
            bookingGroup.setOtherAccount("");
        } else {
            bookingGroup.setOtherAccount(bookingsGroup.getOtherAccount());
        }
        return bookingGroup;
    }

    static List<BookingPeriod> mapBookingPeriods(List<de.adorsys.smartanalytics.api.BookingPeriod> bookingPeriods) {
        if (bookingPeriods == null) {
            return null;
        }
        return bookingPeriods.stream().map(bookingPeriod -> SmartanalyticsMapper.toBookingPeriod(bookingPeriod)).collect(Collectors.toList());
    }

    private static BookingPeriod toBookingPeriod(de.adorsys.smartanalytics.api.BookingPeriod bookingPeriod) {
        BookingPeriod period = BookingPeriod.builder().build();
        BeanUtils.copyProperties((Object)bookingPeriod, (Object)period);
        return period;
    }
}

