/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.analytics;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import domain.RuleCategory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CategoriesProvider {
    private List<RuleCategory> categoriesTree;
    private static final Logger LOG = LoggerFactory.getLogger(CategoriesProvider.class);

    @PostConstruct
    public void postConstruct() throws IOException {
        this.loadCategoriesTree();
    }

    private void loadCategoriesTree() throws IOException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResource("analytics/categories.yml").openStream();){
            YAMLFactory ymlFactory = new YAMLFactory();
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)ymlFactory);
            this.categoriesTree = (List)objectMapper.readValue(inputStream, (TypeReference)new TypeReference<List<RuleCategory>>(){});
        }
    }

    public List<RuleCategory> getCategoriesTree() {
        return this.categoriesTree;
    }
}

