/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.multibanking.domain.UserData;
import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.exception.UserNotFoundException;
import de.adorsys.multibanking.service.base.StorageUserService;
import de.adorsys.multibanking.service.base.UserObjectService;
import de.adorsys.multibanking.service.producer.OnlineBankingServiceProducer;
import de.adorsys.multibanking.utils.FQNUtils;
import de.adorsys.multibanking.utils.Ids;
import domain.BankApi;
import domain.BankApiUser;
import java.util.ArrayList;
import java.util.Date;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import spi.OnlineBankingService;

@Service
public class UserDataService {
    @Autowired
    private UserObjectService uos;
    @Autowired
    private OnlineBankingServiceProducer bankingServiceProducer;
    @Autowired
    private StorageUserService storageUserService;
    @Autowired
    private DocumentSafeService documentSafeService;

    public UserData load() {
        return this.uos.load(FQNUtils.userDataFQN(), UserDataService.valueType()).orElseThrow(() -> new UserNotFoundException(this.uos.auth().getUserID().getValue()));
    }

    public boolean exists() {
        return this.uos.documentExists(FQNUtils.userDataFQN(), UserDataService.valueType());
    }

    public void store(UserData userData) {
        this.uos.store(FQNUtils.userDataFQN(), UserDataService.valueType(), userData);
    }

    public DSDocument loadDocument() {
        return this.documentSafeService.readDocument(this.uos.auth(), FQNUtils.userDataFQN());
    }

    public UserData createUser(Date expire) {
        UserIDAuth userIDAuth = this.uos.auth();
        UserEntity userEntity = new UserEntity();
        userEntity.setApiUser(new ArrayList<BankApiUser>());
        userEntity.setId(userIDAuth.getUserID().getValue());
        userEntity.setExpireUser(expire);
        UserData userData = new UserData();
        userData.setUserEntity(userEntity);
        this.store(userData);
        return userData;
    }

    private static TypeReference<UserData> valueType() {
        return new TypeReference<UserData>(){};
    }

    public BankApiUser checkApiRegistration(BankApi bankApi, String bankCode) {
        OnlineBankingService onlineBankingService;
        OnlineBankingService onlineBankingService2 = onlineBankingService = bankApi != null ? this.bankingServiceProducer.getBankingService(bankApi) : this.bankingServiceProducer.getBankingService(bankCode);
        if (onlineBankingService.userRegistrationRequired()) {
            if (!this.storageUserService.userExists(this.uos.auth().getUserID())) {
                throw new BaseException("Storage user with id: " + this.uos.auth().getUserID().getValue() + " non existent ");
            }
            UserData userData = this.load();
            UserEntity userEntity = userData.getUserEntity();
            return userEntity.getApiUser().stream().filter(bankApiUser -> bankApiUser.getBankApi() == onlineBankingService.bankApi()).findFirst().orElseGet(() -> {
                BankApiUser bankApiUser = onlineBankingService.registerUser(Ids.uuid());
                userEntity.getApiUser().add(bankApiUser);
                this.store(userData);
                return bankApiUser;
            });
        }
        BankApiUser bankApiUser2 = new BankApiUser();
        bankApiUser2.setBankApi(onlineBankingService.bankApi());
        return bankApiUser2;
    }
}

