/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.jwk.JWK;
import de.adorsys.multibanking.domain.UserAgentCredentials;
import de.adorsys.multibanking.domain.UserData;
import de.adorsys.multibanking.service.base.UserObjectService;
import de.adorsys.multibanking.service.crypto.KeyGen;
import de.adorsys.multibanking.utils.FQNUtils;
import de.adorsys.multibanking.utils.Ids;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserAgentCredentialsService {
    @Autowired
    private UserObjectService uos;

    public UserAgentCredentials load(String userAgentId) {
        return this.uos.load(FQNUtils.userAgentCredentialFQN(userAgentId), UserAgentCredentialsService.valueType()).orElseThrow(() -> this.uos.resourceNotFound(UserData.class, this.uos.auth().getUserID().getValue()));
    }

    public boolean exists(String userAgentId) {
        return this.uos.documentExists(FQNUtils.userAgentCredentialFQN(userAgentId), UserAgentCredentialsService.valueType());
    }

    public void store(UserAgentCredentials userAgentCredentials) {
        this.uos.store(FQNUtils.userAgentCredentialFQN(userAgentCredentials.getUserAgentId()), UserAgentCredentialsService.valueType(), userAgentCredentials);
    }

    public JWK newAESKey(String keyId, EncryptionMethod encryptionMethod) {
        return KeyGen.newAESKey(keyId, encryptionMethod);
    }

    public String newUUID() {
        return Ids.uuid();
    }

    private static TypeReference<UserAgentCredentials> valueType() {
        return new TypeReference<UserAgentCredentials>(){};
    }
}

