/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.multibanking.domain.AccountSynchPref;
import de.adorsys.multibanking.domain.AnonymizedBookingEntity;
import de.adorsys.multibanking.domain.BankAccessData;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccountData;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.domain.BookingFile;
import de.adorsys.multibanking.domain.UserData;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.exception.UnexistentBookingFileException;
import de.adorsys.multibanking.service.BankAccessCredentialService;
import de.adorsys.multibanking.service.BankAccessService;
import de.adorsys.multibanking.service.BankAccountService;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.UserDataService;
import de.adorsys.multibanking.service.analytics.AnalyticsService;
import de.adorsys.multibanking.service.analytics.AnonymizationService;
import de.adorsys.multibanking.service.analytics.CategoriesProvider;
import de.adorsys.multibanking.service.analytics.SmartAnalyticsService;
import de.adorsys.multibanking.service.analytics.SmartanalyticsMapper;
import de.adorsys.multibanking.service.base.UserObjectService;
import de.adorsys.multibanking.service.helper.BookingHelper;
import de.adorsys.multibanking.service.producer.OnlineBankingServiceProducer;
import de.adorsys.multibanking.utils.FQNUtils;
import de.adorsys.multibanking.utils.Ids;
import de.adorsys.smartanalytics.api.AnalyticsResult;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.Booking;
import domain.LoadBookingsResponse;
import domain.StandingOrder;
import exception.InvalidPinException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import spi.OnlineBankingService;
import utils.Utils;

@Service
public class BookingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BookingService.class);
    @Autowired
    private UserObjectService uos;
    @Autowired
    private UserDataService uds;
    @Autowired
    private BankAccessService bankAccessService;
    @Autowired
    private BankAccountService bankAccountService;
    @Autowired
    private BankAccessCredentialService credentialService;
    @Autowired
    private SmartAnalyticsService smartAnalyticsService;
    @Autowired
    private AnalyticsService analyticsService;
    @Autowired
    private BankService bankService;
    @Autowired
    private OnlineBankingServiceProducer bankingServiceProducer;
    @Autowired
    private AnonymizationService anonymizationService;
    @Autowired
    private CategoriesProvider categoriesProvider;
    @Autowired
    private DocumentSafeService documentSafeService;

    public DSDocument getBookings(String accessId, String accountId, String period) {
        BankAccountData bankAccountData = this.uds.load().bankAccountDataOrException(accessId, accountId);
        DocumentFQN bookingFQN = FQNUtils.bookingFQN(accessId, accountId, period);
        if (!bankAccountData.containsBookingFileOfPeriod(period).booleanValue()) {
            throw new UnexistentBookingFileException(bookingFQN.getValue());
        }
        return this.documentSafeService.readDocument(this.uos.auth(), bookingFQN);
    }

    public List<BookingEntity> getAllBookingsAlList(String accessId, String accountId) {
        return this.loadAllBookings(this.uds.load(), accessId, accountId);
    }

    public void syncBookings(String accessId, String accountId, BankApi bankApi, String pin) {
        UserData userData = this.uds.load();
        BankAccountData bankAccountData = userData.bankAccountDataOrException(accessId, accountId);
        bankAccountData.updateSyncStatus(BankAccount.SyncStatus.SYNC);
        this.uos.flush();
        BankAccessEntity bankAccess = userData.bankAccessDataOrException(accessId).getBankAccess();
        BankAccountEntity bankAccount = bankAccountData.getBankAccount();
        LoadBookingsResponse response = this.loadBookingsOnline(bankApi, bankAccess, bankAccount, pin);
        bankAccount.setBankAccountBalance(response.getBankAccountBalance());
        if (bankAccess.isStoreBookings()) {
            bankAccount.setLastSync(LocalDateTime.now());
            this.bankAccountService.saveBankAccount(bankAccount);
        }
        if (!bankAccess.isTemporary()) {
            this.bankAccessService.updateBankAccess(bankAccess);
        }
        this.processBookings(userData, bankAccess, bankAccount, response);
    }

    private void processBookings(UserData userData, BankAccessEntity bankAccess, BankAccountEntity bankAccount, LoadBookingsResponse response) {
        AccountSynchPref accountSynchPref = this.bankAccountService.findAccountSynchPref(bankAccess.getId(), bankAccount.getId());
        Map<String, List<BookingEntity>> bookings = BookingHelper.mapBookings(bankAccount, accountSynchPref, response.getBookings());
        BankAccountData bankAccountData = userData.bankAccountDataOrException(bankAccess.getId(), bankAccount.getId());
        Map<String, List<BookingEntity>> processBookingPeriods = this.storeBookings(bankAccountData, response.getStandingOrders(), bankAccess.isStoreBookings(), bookings);
        this.bankAccountService.saveStandingOrders(bankAccount, response.getStandingOrders());
        bankAccountData.updateSyncStatus(BankAccount.SyncStatus.READY);
        this.uos.flush();
        if (bankAccess.isCategorizeBookings() || bankAccess.isStoreAnalytics()) {
            bankAccountData = userData.bankAccountDataOrException(bankAccess.getId(), bankAccount.getId());
            List<BookingEntity> bookingEntities = this.loadAllBookings(userData, bankAccess.getId(), bankAccount.getId());
            LocalDate analyticsDate = LocalDate.now();
            AnalyticsResult analyticsResult = this.smartAnalyticsService.analyzeBookings(bankAccess.getUserId(), bookingEntities);
            if (analyticsResult != null) {
                if (!response.getOnlineBankingService().bookingsCategorized()) {
                    SmartanalyticsMapper.applyCategories(bookingEntities, analyticsResult, this.categoriesProvider.getCategoriesTree());
                }
                if (bankAccess.isStoreAnalytics()) {
                    Map<String, List<BookingEntity>> mapBookings = BookingHelper.reMapBookings(bookingEntities);
                    processBookingPeriods = this.storeBookings(bankAccountData, response.getStandingOrders(), bankAccess.isStoreBookings(), bookings);
                    this.analyticsService.saveAccountAnalytics(bankAccount, analyticsResult, analyticsDate);
                    this.analyticsService.identifyAndStoreContracts(bankAccount.getUserId(), bankAccount.getId(), analyticsResult);
                }
                if (bankAccess.isStoreAnalytics() && bankAccess.isStoreAnonymizedBookings()) {
                    Set<Map.Entry<String, List<BookingEntity>>> entries = processBookingPeriods.entrySet();
                    entries.forEach(entry -> {
                        String period = (String)entry.getKey();
                        List<AnonymizedBookingEntity> anonymizedBookings = this.anonymizationService.anonymizeAndStoreBookingsAsync((List)entry.getValue());
                        DocumentFQN anonymizedBookingsFQN = FQNUtils.anonymizedBookingFQN(bankAccess.getId(), bankAccount.getId(), period);
                        this.uos.store(anonymizedBookingsFQN, this.anonymizedBookingsListType(), anonymizedBookings);
                    });
                }
            }
        }
    }

    private List<BookingEntity> loadAllBookings(UserData userData, String accessId, String accountId) {
        BankAccountData bankAccountData = userData.bankAccountDataOrException(accessId, accountId);
        List<BookingFile> bookingFiles = bankAccountData.getBookingFiles();
        ArrayList<BookingEntity> result = new ArrayList<BookingEntity>();
        bookingFiles.forEach(bookingFile -> {
            String period = bookingFile.getPeriod();
            if (bookingFile.getNumberOfRecords() > 0) {
                DocumentFQN bookingFQN = FQNUtils.bookingFQN(accessId, accountId, period);
                List existingBookings = this.uos.load(bookingFQN, BookingService.listType()).orElse(new ArrayList());
                result.addAll(existingBookings);
            }
        });
        return result;
    }

    private LoadBookingsResponse loadBookingsOnline(BankApi bankApi, BankAccessEntity bankAccess, BankAccountEntity bankAccount, String pin) {
        BankApiUser bankApiUser = this.uds.checkApiRegistration(bankApi, bankAccess.getBankCode());
        OnlineBankingService onlineBankingService = this.checkAndGetOnlineBankingService(bankAccess, bankAccount, pin, bankApiUser);
        String mappedBlz = this.bankService.findByBankCode(bankAccess.getBankCode()).orElseThrow(() -> new ResourceNotFoundException(BankEntity.class, bankAccess.getBankCode())).getBlzHbci();
        try {
            LoadBookingsResponse response = onlineBankingService.loadBookings(bankApiUser, (BankAccess)bankAccess, mappedBlz, (BankAccount)bankAccount, pin);
            response.setOnlineBankingService(onlineBankingService);
            return response;
        }
        catch (InvalidPinException e) {
            try {
                this.credentialService.setInvalidPin(bankAccess.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new de.adorsys.multibanking.exception.InvalidPinException(bankAccess.getId());
        }
    }

    private List<BookingEntity> mergeBookings(List<BookingEntity> dbBookings, List<BookingEntity> newBookings) {
        dbBookings.addAll(newBookings);
        return dbBookings.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BookingEntity>(Comparator.comparing(Booking::getExternalId))), ArrayList::new));
    }

    private OnlineBankingService checkAndGetOnlineBankingService(BankAccessEntity bankAccess, BankAccountEntity bankAccount, String pin, BankApiUser bankApiUser) {
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(bankApiUser.getBankApi());
        if (onlineBankingService.externalBankAccountRequired()) {
            this.checkExternalBankAccountExists(bankAccess, bankAccount, pin, bankApiUser, onlineBankingService);
        }
        return onlineBankingService;
    }

    private void checkExternalBankAccountExists(BankAccessEntity bankAccess, BankAccountEntity bankAccount, String pin, BankApiUser bankApiUser, OnlineBankingService onlineBankingService) {
        UserData userData = this.uds.load();
        String externalAccountId = (String)bankAccount.getExternalIdMap().get(onlineBankingService.bankApi());
        if (externalAccountId == null) {
            String blzHbci = this.bankService.findByBankCode(bankAccess.getBankCode()).orElseThrow(() -> new ResourceNotFoundException(BankEntity.class, bankAccess.getBankCode())).getBlzHbci();
            List apiBankAccounts = onlineBankingService.loadBankAccounts(bankApiUser, (BankAccess)bankAccess, blzHbci, pin, bankAccess.isStorePin());
            BankAccessData bankAccessData = userData.bankAccessDataOrException(bankAccess.getId());
            List<BankAccountData> dbBankAccounts = bankAccessData.getBankAccounts();
            apiBankAccounts.forEach(apiBankAccount -> dbBankAccounts.forEach(dbBankAccountData -> {
                BankAccountEntity dbBankAccount = dbBankAccountData.getBankAccount();
                if (apiBankAccount.getAccountNumber().equals(dbBankAccount.getAccountNumber())) {
                    dbBankAccount.externalId(onlineBankingService.bankApi(), (String)apiBankAccount.getExternalIdMap().get(onlineBankingService.bankApi()));
                    if (bankAccess.getId().equals(dbBankAccount.getId())) {
                        bankAccess.externalId(onlineBankingService.bankApi(), (String)apiBankAccount.getExternalIdMap().get(onlineBankingService.bankApi()));
                    }
                }
            }));
            this.uds.store(userData);
        }
    }

    private Map<String, List<BookingEntity>> storeBookings(BankAccountData bankAccountData, List<StandingOrder> standingOrders, boolean persist, Map<String, List<BookingEntity>> bookings) {
        HashMap<String, List<BookingEntity>> processBookingPeriods = new HashMap<String, List<BookingEntity>>();
        String accessId = bankAccountData.getBankAccount().getBankAccessId();
        String accountId = bankAccountData.getBankAccount().getId();
        List<BookingFile> bookingFiles = bankAccountData.getBookingFiles();
        Set<Map.Entry<String, List<BookingEntity>>> entrySet = bookings.entrySet();
        for (Map.Entry<String, List<BookingEntity>> entry : entrySet) {
            List<BookingEntity> bookingEntities = entry.getValue();
            bookingEntities.forEach(booking -> standingOrders.stream().filter(so -> so.getAmount().negate().compareTo(booking.getAmount()) == 0 && Utils.inCycle((LocalDate)booking.getValutaDate(), (int)so.getExecutionDay()) && Utils.usageContains((String)booking.getUsage(), (String)so.getUsage())).findFirst().ifPresent(standingOrder -> {
                booking.setOtherAccount(standingOrder.getOtherAccount());
                booking.setStandingOrder(true);
            }));
            String period = entry.getKey();
            DocumentFQN bookingFQN = FQNUtils.bookingFQN(accessId, accountId, period);
            List existingBookings = this.uos.load(bookingFQN, BookingService.listType()).orElse(new ArrayList());
            bookingEntities = this.mergeBookings(existingBookings, bookingEntities);
            Optional<BookingFile> bookingFile = bankAccountData.findBookingFileOfPeriod(period);
            if (!bookingFile.isPresent()) {
                bookingFile = Optional.of(new BookingFile());
                bookingFile.get().setPeriod(period);
                bookingFile.get().setLastUpdate(LocalDateTime.now());
                bankAccountData.update(Collections.singletonList(bookingFile.get()));
            }
            bookingFile.get().setNumberOfRecords(bookingEntities.size());
            Collections.sort(bookingEntities, (o1, o2) -> o2.getBookingDate().compareTo(o1.getBookingDate()));
            processBookingPeriods.put(period, bookingEntities);
            if (!persist) continue;
            bookingEntities.forEach(b -> {
                if (StringUtils.isBlank((CharSequence)b.getId())) {
                    b.setId(Ids.uuid());
                }
            });
            this.uos.store(bookingFQN, BookingService.listType(), bookingEntities);
        }
        return processBookingPeriods;
    }

    private static TypeReference<List<BookingEntity>> listType() {
        return new TypeReference<List<BookingEntity>>(){};
    }

    private TypeReference<List<AnonymizedBookingEntity>> anonymizedBookingsListType() {
        return new TypeReference<List<AnonymizedBookingEntity>>(){};
    }
}

