/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.exception.handler;

import de.adorsys.multibanking.exception.base.ErrorKeyException;
import de.adorsys.multibanking.exception.base.ParametrizedMessageException;
import de.adorsys.multibanking.exception.domain.MultibankingError;
import java.util.HashMap;
import java.util.concurrent.CompletionException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class ExceptionHandlerAdvice
extends ResponseEntityExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandlerAdvice.class);

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        if (HttpStatus.INTERNAL_SERVER_ERROR.equals((Object)status)) {
            request.setAttribute("javax.servlet.error.exception", (Object)ex, 0);
        }
        this.handleLogging(ex);
        if (body == null) {
            body = MultibankingError.builder().status(status).exception(ex).build();
        }
        if (headers == null) {
            headers = new HttpHeaders();
        }
        return new ResponseEntity(body, (MultiValueMap)headers, status);
    }

    private ResponseEntity<Object> handleInternal(Exception ex, MultibankingError error, HttpHeaders headers, HttpStatus status, WebRequest request) {
        ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(ex.getClass(), ResponseStatus.class);
        if (error == null && responseStatus != null && responseStatus.value() != null) {
            error = MultibankingError.builder().status(responseStatus.value()).text(responseStatus.reason()).exception(ex).build();
        }
        if (error == null) {
            error = MultibankingError.builder().status(status).exception(ex).build();
        }
        return this.handleExceptionInternal(ex, error, headers, status, request);
    }

    @ExceptionHandler
    @ResponseBody
    protected ResponseEntity<Object> handleErrorMessageException(ErrorKeyException ex, WebRequest request) {
        MultibankingError error = MultibankingError.builder().status(ex.getHttpStatus()).exception(ex).text(ex.getErrorKey()).moreInfo(ex.getMoreInfo()).build();
        return this.handleExceptionInternal(ex, error, null, error.getStatus(), request);
    }

    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Object> handleException(CompletionException e, WebRequest request) {
        Throwable cause = e.getCause();
        if (RestClientResponseException.class.isAssignableFrom(cause.getClass())) {
            return this.handleRestClientResponseException((RestClientResponseException)cause, request);
        }
        if (ParametrizedMessageException.class.isAssignableFrom(cause.getClass())) {
            return this.handleException((ParametrizedMessageException)cause, request);
        }
        return this.handleInternal(e, null, null, null, null);
    }

    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Object> handleAccessDeniedException(AccessDeniedException e, WebRequest request) {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            LOG.info("User [{}] access denied to [{}] [{}]", new Object[]{httpServletRequest.getRemoteUser(), httpServletRequest.getMethod(), httpServletRequest.getRequestURI()});
        }
        catch (Exception ex) {
            LOG.info("Can't LOG: ", (Object)ex.getMessage());
        }
        MultibankingError error = MultibankingError.builder().status(HttpStatus.UNAUTHORIZED).text("error.accessDenied").exception((Throwable)e).build();
        return this.handleExceptionInternal((Exception)e, error, null, error.getStatus(), request);
    }

    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Object> handleException(ParametrizedMessageException e, WebRequest request) {
        ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class);
        MultibankingError error = null;
        error = responseStatus != null ? MultibankingError.builder().status(responseStatus.value()).text(responseStatus.reason()).params(e.getParamsMap()).exception(e).build() : MultibankingError.builder().status(HttpStatus.BAD_REQUEST).text(e.getMessage()).params(e.getParamsMap()).exception(e).build();
        return this.handleExceptionInternal(e, error, null, error.getStatus(), request);
    }

    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Object> handleRestClientResponseException(RestClientResponseException e, WebRequest request) {
        return this.handleExceptionInternal((Exception)e, e.getResponseBodyAsByteArray(), e.getResponseHeaders(), HttpStatus.valueOf((int)e.getRawStatusCode()), request);
    }

    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Object> handleConstraintViolationException(ConstraintViolationException ex, WebRequest request) {
        MultibankingError error = MultibankingError.builder().exception((Throwable)ex).build();
        error.addValidationErrors(ex.getConstraintViolations());
        return this.handleExceptionInternal((Exception)ex, error, null, HttpStatus.BAD_REQUEST, request);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        MultibankingError error = MultibankingError.builder().status(HttpStatus.BAD_REQUEST).text("parameter.error").renderedMessage("Missing parameter with name {parameterName} and type {parameterType}").exception((Throwable)ex).build();
        error.getParams().put("parameterName", ex.getParameterName());
        error.getParams().put("parameterType", ex.getParameterType());
        return this.handleExceptionInternal((Exception)ex, error, headers, error.getStatus(), request);
    }

    protected ResponseEntity<Object> handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        StringBuilder supported = new StringBuilder();
        ex.getSupportedMediaTypes().forEach(t -> supported.append(t).append(" "));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("supported", supported.toString());
        paramMap.put("actual", ex.getContentType().toString());
        MultibankingError error = MultibankingError.builder().status(HttpStatus.UNSUPPORTED_MEDIA_TYPE).text("mediaType.unsupported").renderedMessage("Hypermedia with type {actual} not supported. Following Mediatypes are supported {supported}").params(paramMap).exception((Throwable)ex).build();
        return this.handleExceptionInternal((Exception)ex, error, headers, error.getStatus(), request);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        MultibankingError error = MultibankingError.builder().status(HttpStatus.BAD_REQUEST).exception((Throwable)ex).build();
        if (ex.getBindingResult().hasFieldErrors()) {
            error.addValidationErrors(ex.getBindingResult().getFieldErrors());
        }
        if (ex.getBindingResult().hasGlobalErrors()) {
            error.addGlobalErrors(ex.getBindingResult().getGlobalErrors());
        }
        return this.handleExceptionInternal((Exception)ex, error, headers, error.getStatus(), request);
    }

    protected ResponseEntity<Object> handleTypeMismatch(TypeMismatchException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("parameterValue", "" + ex.getValue());
        paramMap.put("parameterType", ex.getRequiredType().getSimpleName());
        if (ex instanceof MethodArgumentTypeMismatchException) {
            paramMap.put("parameterName", ((MethodArgumentTypeMismatchException)ex).getName());
        }
        MultibankingError error = MultibankingError.builder().status(HttpStatus.BAD_REQUEST).text("argument.typemismatch").renderedMessage("The parameter {parameterName} of value {parameterValue} could not be converted to type {parameterType}").params(paramMap).exception((Throwable)ex).build();
        return this.handleExceptionInternal((Exception)ex, error, headers, error.getStatus(), request);
    }

    protected ResponseEntity<Object> handleBindException(BindException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        MultibankingError error = MultibankingError.builder().status(HttpStatus.BAD_REQUEST).exception((Throwable)ex).build();
        if (ex.getBindingResult().hasFieldErrors()) {
            error.addValidationErrors(ex.getBindingResult().getFieldErrors());
        }
        if (ex.getBindingResult().hasGlobalErrors()) {
            error.addGlobalErrors(ex.getBindingResult().getGlobalErrors());
        }
        return this.handleExceptionInternal((Exception)ex, error, headers, error.getStatus(), request);
    }

    private void handleLogging(Exception ex) {
        this.handleLogging(ex, false);
    }

    private void handleLogging(Exception ex, boolean skipStacktrace) {
        LOG.warn("Exception handled by " + ExceptionHandlerAdvice.class.getName() + ": " + ex.getClass().getName() + " : " + ex.getLocalizedMessage());
        if (LOG.isDebugEnabled() && !skipStacktrace) {
            LOG.debug("Exception details: ", (Throwable)ex);
        }
    }
}

