/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.exception.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@ApiModel(description="SubError detail information", value="SubError")
public class SubError
implements Serializable {
    private static final long serialVersionUID = 3656014078861748932L;
    @JsonIgnore
    private Throwable exception;
    @ApiModelProperty(value="The severity of the error", example="WARNING")
    @JsonProperty(value="severity")
    private Severity severity = Severity.ERROR;
    @ApiModelProperty(value="The key (i18n) for the error message.", example="message.key")
    @JsonProperty(value="text")
    private String text = "error.unknown";
    @ApiModelProperty(value="The default text (i18n) for the error message, eventualy in the user language.", example="Message text {param-key}")
    @JsonProperty(value="messageText")
    private String renderedMessage;
    @ApiModelProperty(value="List of parameter associated with the message (optional)")
    @JsonProperty(value="params")
    private Map<String, String> params;
    @ApiModelProperty(value="Developer level detailed exception message (optional)", example="An exceptional message")
    @JsonProperty(value="developer_text")
    private String developerText;
    @ApiModelProperty(value="Additional information for error handling (optional)", example="More info")
    @JsonProperty(value="more_info")
    private String moreInfo;

    public static SubErrorBuilder builder() {
        return new SubErrorBuilder(){

            @Override
            public SubError build() {
                return this.postBuild(super.build());
            }

            private SubError postBuild(SubError error) {
                if (error.exception != null && StringUtils.isBlank((CharSequence)error.developerText)) {
                    error.developerText = error.exception.getLocalizedMessage();
                }
                return error;
            }
        };
    }

    public SubErrorBuilder toBuilder() {
        return new SubErrorBuilder().exception(this.exception).severity(this.severity).text(this.text).renderedMessage(this.renderedMessage).params(this.params).developerText(this.developerText).moreInfo(this.moreInfo);
    }

    public Throwable getException() {
        return this.exception;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getText() {
        return this.text;
    }

    public String getRenderedMessage() {
        return this.renderedMessage;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getDeveloperText() {
        return this.developerText;
    }

    public String getMoreInfo() {
        return this.moreInfo;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setRenderedMessage(String renderedMessage) {
        this.renderedMessage = renderedMessage;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void setDeveloperText(String developerText) {
        this.developerText = developerText;
    }

    public void setMoreInfo(String moreInfo) {
        this.moreInfo = moreInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubError)) {
            return false;
        }
        SubError other = (SubError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Throwable this$exception = this.getException();
        Throwable other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        Severity this$severity = this.getSeverity();
        Severity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$renderedMessage = this.getRenderedMessage();
        String other$renderedMessage = other.getRenderedMessage();
        if (this$renderedMessage == null ? other$renderedMessage != null : !this$renderedMessage.equals(other$renderedMessage)) {
            return false;
        }
        Map<String, String> this$params = this.getParams();
        Map<String, String> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        String this$developerText = this.getDeveloperText();
        String other$developerText = other.getDeveloperText();
        if (this$developerText == null ? other$developerText != null : !this$developerText.equals(other$developerText)) {
            return false;
        }
        String this$moreInfo = this.getMoreInfo();
        String other$moreInfo = other.getMoreInfo();
        return !(this$moreInfo == null ? other$moreInfo != null : !this$moreInfo.equals(other$moreInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Throwable $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        Severity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $renderedMessage = this.getRenderedMessage();
        result = result * 59 + ($renderedMessage == null ? 43 : $renderedMessage.hashCode());
        Map<String, String> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        String $developerText = this.getDeveloperText();
        result = result * 59 + ($developerText == null ? 43 : $developerText.hashCode());
        String $moreInfo = this.getMoreInfo();
        result = result * 59 + ($moreInfo == null ? 43 : $moreInfo.hashCode());
        return result;
    }

    public String toString() {
        return "SubError(exception=" + this.getException() + ", severity=" + (Object)((Object)this.getSeverity()) + ", text=" + this.getText() + ", renderedMessage=" + this.getRenderedMessage() + ", params=" + this.getParams() + ", developerText=" + this.getDeveloperText() + ", moreInfo=" + this.getMoreInfo() + ")";
    }

    public SubError(Throwable exception, Severity severity, String text, String renderedMessage, Map<String, String> params, String developerText, String moreInfo) {
        this.exception = exception;
        this.severity = severity;
        this.text = text;
        this.renderedMessage = renderedMessage;
        this.params = params;
        this.developerText = developerText;
        this.moreInfo = moreInfo;
    }

    public static class SubErrorBuilder {
        private Throwable exception;
        private Severity severity;
        private String text;
        private String renderedMessage;
        private Map<String, String> params;
        private String developerText;
        private String moreInfo;

        SubErrorBuilder() {
        }

        public SubErrorBuilder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public SubErrorBuilder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public SubErrorBuilder text(String text) {
            this.text = text;
            return this;
        }

        public SubErrorBuilder renderedMessage(String renderedMessage) {
            this.renderedMessage = renderedMessage;
            return this;
        }

        public SubErrorBuilder params(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public SubErrorBuilder developerText(String developerText) {
            this.developerText = developerText;
            return this;
        }

        public SubErrorBuilder moreInfo(String moreInfo) {
            this.moreInfo = moreInfo;
            return this;
        }

        public SubError build() {
            return new SubError(this.exception, this.severity, this.text, this.renderedMessage, this.params, this.developerText, this.moreInfo);
        }

        public String toString() {
            return "SubError.SubErrorBuilder(exception=" + this.exception + ", severity=" + (Object)((Object)this.severity) + ", text=" + this.text + ", renderedMessage=" + this.renderedMessage + ", params=" + this.params + ", developerText=" + this.developerText + ", moreInfo=" + this.moreInfo + ")";
        }
    }

    public static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }
}

