/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.exception.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import de.adorsys.multibanking.exception.domain.LowerCaseClassNameResolver;
import de.adorsys.multibanking.exception.domain.SubError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.CUSTOM, visible=true)
@JsonTypeIdResolver(value=LowerCaseClassNameResolver.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@ApiModel(description="Error detail information", value="Error")
public class MultibankingError
implements Serializable {
    private static final long serialVersionUID = -6789536775158955859L;
    @JsonIgnore
    private HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
    @JsonIgnore
    private Throwable exception;
    @ApiModelProperty(value="The http status code", example="401")
    private int http = this.status.value();
    @ApiModelProperty(value="The occurence time stamp 'yyyy-MM-dd'T'HH:mm:ss'Z''.", example="2018-02-12T04:33:38Z")
    private String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));
    @ApiModelProperty(value="The severity of the error", example="WARNING")
    @JsonProperty(value="severity")
    private Severity severity = Severity.ERROR;
    @ApiModelProperty(value="The key (i18n) for the error message.", example="message.key")
    @JsonProperty(value="text")
    private String text = "error.unknown";
    @ApiModelProperty(value="The default text (i18n) for the error message, eventualy in the user language.", example="Message text {param-key}")
    @JsonProperty(value="messageText")
    private String renderedMessage;
    @ApiModelProperty(value="List of parameter associated with the message (optional)")
    @JsonProperty(value="params")
    private Map<String, String> params;
    @ApiModelProperty(value="Developer level detailed exception message (optional)", example="An exceptional message")
    @JsonProperty(value="developer_text")
    private String developerText;
    @ApiModelProperty(value="Additional information for error handling (optional)", example="More info")
    @JsonProperty(value="more_info")
    private String moreInfo;
    @ApiModelProperty(value="List of sub errors (optional)")
    @JsonProperty(value="sub_errors")
    private List<SubError> subErrors;

    public void addValidationErrors(List<FieldError> fieldErrors) {
        fieldErrors.forEach(this::addValidationError);
    }

    public void addGlobalErrors(List<ObjectError> globalErrors) {
        globalErrors.forEach(this::addValidationError);
    }

    public void addValidationErrors(Set<ConstraintViolation<?>> constraintViolations) {
        constraintViolations.forEach(this::addValidationError);
    }

    private void addValidationError(ConstraintViolation<?> cv) {
        this.addValidationError(cv.getRootBeanClass().getSimpleName(), ((PathImpl)cv.getPropertyPath()).getLeafNode().asString(), cv.getInvalidValue(), cv.getMessage());
    }

    private void addValidationError(String object, String field, Object rejectedValue, String message) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectValue", object);
        if (field != null) {
            params.put("fieldName", field);
        }
        if (rejectedValue != null) {
            params.put("fieldValue", "" + rejectedValue);
        }
        SubError subError = SubError.builder().text("error.validation").renderedMessage(message).params(params).build();
        this.addSubError(subError);
    }

    private void addValidationError(String object, String message) {
        this.addValidationError(object, null, null, message);
    }

    private void addSubError(SubError subError) {
        if (this.subErrors == null) {
            this.subErrors = new ArrayList<SubError>();
        }
        this.subErrors.add(subError);
    }

    private void addValidationError(FieldError fieldError) {
        this.addValidationError(fieldError.getObjectName(), fieldError.getField(), fieldError.getRejectedValue(), fieldError.getDefaultMessage());
    }

    private void addValidationError(ObjectError objectError) {
        this.addValidationError(objectError.getObjectName(), objectError.getDefaultMessage());
    }

    public static MultibankingErrorBuilder builder() {
        return new MultibankingErrorBuilder(){

            @Override
            public MultibankingError build() {
                return this.postBuild(super.build());
            }

            private MultibankingError postBuild(MultibankingError error) {
                error.http = error.status != null ? error.status.value() : error.http;
                if (error.exception != null && StringUtils.isBlank((CharSequence)error.developerText)) {
                    error.developerText = error.exception.getLocalizedMessage();
                }
                return error;
            }
        };
    }

    public MultibankingErrorBuilder toBuilder() {
        return new MultibankingErrorBuilder().status(this.status).exception(this.exception).http(this.http).timestamp(this.timestamp).severity(this.severity).text(this.text).renderedMessage(this.renderedMessage).params(this.params).developerText(this.developerText).moreInfo(this.moreInfo).subErrors(this.subErrors);
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public Throwable getException() {
        return this.exception;
    }

    public int getHttp() {
        return this.http;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getText() {
        return this.text;
    }

    public String getRenderedMessage() {
        return this.renderedMessage;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getDeveloperText() {
        return this.developerText;
    }

    public String getMoreInfo() {
        return this.moreInfo;
    }

    public List<SubError> getSubErrors() {
        return this.subErrors;
    }

    public void setStatus(HttpStatus status) {
        this.status = status;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public void setHttp(int http) {
        this.http = http;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setRenderedMessage(String renderedMessage) {
        this.renderedMessage = renderedMessage;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void setDeveloperText(String developerText) {
        this.developerText = developerText;
    }

    public void setMoreInfo(String moreInfo) {
        this.moreInfo = moreInfo;
    }

    public void setSubErrors(List<SubError> subErrors) {
        this.subErrors = subErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultibankingError)) {
            return false;
        }
        MultibankingError other = (MultibankingError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpStatus this$status = this.getStatus();
        HttpStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Throwable this$exception = this.getException();
        Throwable other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        if (this.getHttp() != other.getHttp()) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        Severity this$severity = this.getSeverity();
        Severity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$renderedMessage = this.getRenderedMessage();
        String other$renderedMessage = other.getRenderedMessage();
        if (this$renderedMessage == null ? other$renderedMessage != null : !this$renderedMessage.equals(other$renderedMessage)) {
            return false;
        }
        Map<String, String> this$params = this.getParams();
        Map<String, String> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        String this$developerText = this.getDeveloperText();
        String other$developerText = other.getDeveloperText();
        if (this$developerText == null ? other$developerText != null : !this$developerText.equals(other$developerText)) {
            return false;
        }
        String this$moreInfo = this.getMoreInfo();
        String other$moreInfo = other.getMoreInfo();
        if (this$moreInfo == null ? other$moreInfo != null : !this$moreInfo.equals(other$moreInfo)) {
            return false;
        }
        List<SubError> this$subErrors = this.getSubErrors();
        List<SubError> other$subErrors = other.getSubErrors();
        return !(this$subErrors == null ? other$subErrors != null : !((Object)this$subErrors).equals(other$subErrors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultibankingError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Throwable $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        result = result * 59 + this.getHttp();
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        Severity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $renderedMessage = this.getRenderedMessage();
        result = result * 59 + ($renderedMessage == null ? 43 : $renderedMessage.hashCode());
        Map<String, String> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        String $developerText = this.getDeveloperText();
        result = result * 59 + ($developerText == null ? 43 : $developerText.hashCode());
        String $moreInfo = this.getMoreInfo();
        result = result * 59 + ($moreInfo == null ? 43 : $moreInfo.hashCode());
        List<SubError> $subErrors = this.getSubErrors();
        result = result * 59 + ($subErrors == null ? 43 : ((Object)$subErrors).hashCode());
        return result;
    }

    public String toString() {
        return "MultibankingError(status=" + this.getStatus() + ", exception=" + this.getException() + ", http=" + this.getHttp() + ", timestamp=" + this.getTimestamp() + ", severity=" + (Object)((Object)this.getSeverity()) + ", text=" + this.getText() + ", renderedMessage=" + this.getRenderedMessage() + ", params=" + this.getParams() + ", developerText=" + this.getDeveloperText() + ", moreInfo=" + this.getMoreInfo() + ", subErrors=" + this.getSubErrors() + ")";
    }

    public MultibankingError(HttpStatus status, Throwable exception, int http, String timestamp, Severity severity, String text, String renderedMessage, Map<String, String> params, String developerText, String moreInfo, List<SubError> subErrors) {
        this.status = status;
        this.exception = exception;
        this.http = http;
        this.timestamp = timestamp;
        this.severity = severity;
        this.text = text;
        this.renderedMessage = renderedMessage;
        this.params = params;
        this.developerText = developerText;
        this.moreInfo = moreInfo;
        this.subErrors = subErrors;
    }

    public static class MultibankingErrorBuilder {
        private HttpStatus status;
        private Throwable exception;
        private int http;
        private String timestamp;
        private Severity severity;
        private String text;
        private String renderedMessage;
        private Map<String, String> params;
        private String developerText;
        private String moreInfo;
        private List<SubError> subErrors;

        MultibankingErrorBuilder() {
        }

        public MultibankingErrorBuilder status(HttpStatus status) {
            this.status = status;
            return this;
        }

        public MultibankingErrorBuilder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public MultibankingErrorBuilder http(int http) {
            this.http = http;
            return this;
        }

        public MultibankingErrorBuilder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public MultibankingErrorBuilder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public MultibankingErrorBuilder text(String text) {
            this.text = text;
            return this;
        }

        public MultibankingErrorBuilder renderedMessage(String renderedMessage) {
            this.renderedMessage = renderedMessage;
            return this;
        }

        public MultibankingErrorBuilder params(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public MultibankingErrorBuilder developerText(String developerText) {
            this.developerText = developerText;
            return this;
        }

        public MultibankingErrorBuilder moreInfo(String moreInfo) {
            this.moreInfo = moreInfo;
            return this;
        }

        public MultibankingErrorBuilder subErrors(List<SubError> subErrors) {
            this.subErrors = subErrors;
            return this;
        }

        public MultibankingError build() {
            return new MultibankingError(this.status, this.exception, this.http, this.timestamp, this.severity, this.text, this.renderedMessage, this.params, this.developerText, this.moreInfo, this.subErrors);
        }

        public String toString() {
            return "MultibankingError.MultibankingErrorBuilder(status=" + this.status + ", exception=" + this.exception + ", http=" + this.http + ", timestamp=" + this.timestamp + ", severity=" + (Object)((Object)this.severity) + ", text=" + this.text + ", renderedMessage=" + this.renderedMessage + ", params=" + this.params + ", developerText=" + this.developerText + ", moreInfo=" + this.moreInfo + ", subErrors=" + this.subErrors + ")";
        }
    }

    public static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }
}

