/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain;

import de.adorsys.multibanking.domain.common.IdentityIf;
import domain.BankAccess;
import io.swagger.annotations.ApiModelProperty;

public class BankAccessEntity
extends BankAccess
implements IdentityIf {
    private String id;
    @ApiModelProperty(value="Unique identifier of the user owner of this bank access", example="3c149076-13c4-4190-ace3-e30bf8f61526")
    private String userId;
    @ApiModelProperty(value="The personal identification number or password used to login the user with the online banking account.", example="12345")
    private String pin;
    private String pin2;
    @ApiModelProperty(value="Indicates that this is a temporary account. Will be deleted upon expiration", example="false")
    private boolean temporary;
    @ApiModelProperty(value="States whether the PIN shall be stored for asynchronous access to the user's online banking account. Will be stored separately and not returned with user data", example="true")
    private boolean storePin;
    @ApiModelProperty(value="States whether bookings loaded from the user's online banking account shall be stored.", example="true")
    private boolean storeBookings = true;
    @ApiModelProperty(value="States whether bookings loaded from the user's online banking account shall be sent to category service.", example="true")
    private boolean categorizeBookings = true;
    @ApiModelProperty(value="States whether analytics result shall be stored.", example="true")
    private boolean storeAnalytics = true;
    @ApiModelProperty(value="States whether anonymized booking shall be stored.", example="true")
    private boolean storeAnonymizedBookings;

    public BankAccessEntity id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPin() {
        return this.pin;
    }

    public String getPin2() {
        return this.pin2;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isStorePin() {
        return this.storePin;
    }

    public boolean isStoreBookings() {
        return this.storeBookings;
    }

    public boolean isCategorizeBookings() {
        return this.categorizeBookings;
    }

    public boolean isStoreAnalytics() {
        return this.storeAnalytics;
    }

    public boolean isStoreAnonymizedBookings() {
        return this.storeAnonymizedBookings;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    public void setPin2(String pin2) {
        this.pin2 = pin2;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public void setStorePin(boolean storePin) {
        this.storePin = storePin;
    }

    public void setStoreBookings(boolean storeBookings) {
        this.storeBookings = storeBookings;
    }

    public void setCategorizeBookings(boolean categorizeBookings) {
        this.categorizeBookings = categorizeBookings;
    }

    public void setStoreAnalytics(boolean storeAnalytics) {
        this.storeAnalytics = storeAnalytics;
    }

    public void setStoreAnonymizedBookings(boolean storeAnonymizedBookings) {
        this.storeAnonymizedBookings = storeAnonymizedBookings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankAccessEntity)) {
            return false;
        }
        BankAccessEntity other = (BankAccessEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$pin = this.getPin();
        String other$pin = other.getPin();
        if (this$pin == null ? other$pin != null : !this$pin.equals(other$pin)) {
            return false;
        }
        String this$pin2 = this.getPin2();
        String other$pin2 = other.getPin2();
        if (this$pin2 == null ? other$pin2 != null : !this$pin2.equals(other$pin2)) {
            return false;
        }
        if (this.isTemporary() != other.isTemporary()) {
            return false;
        }
        if (this.isStorePin() != other.isStorePin()) {
            return false;
        }
        if (this.isStoreBookings() != other.isStoreBookings()) {
            return false;
        }
        if (this.isCategorizeBookings() != other.isCategorizeBookings()) {
            return false;
        }
        if (this.isStoreAnalytics() != other.isStoreAnalytics()) {
            return false;
        }
        return this.isStoreAnonymizedBookings() == other.isStoreAnonymizedBookings();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BankAccessEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $pin = this.getPin();
        result = result * 59 + ($pin == null ? 43 : $pin.hashCode());
        String $pin2 = this.getPin2();
        result = result * 59 + ($pin2 == null ? 43 : $pin2.hashCode());
        result = result * 59 + (this.isTemporary() ? 79 : 97);
        result = result * 59 + (this.isStorePin() ? 79 : 97);
        result = result * 59 + (this.isStoreBookings() ? 79 : 97);
        result = result * 59 + (this.isCategorizeBookings() ? 79 : 97);
        result = result * 59 + (this.isStoreAnalytics() ? 79 : 97);
        result = result * 59 + (this.isStoreAnonymizedBookings() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "BankAccessEntity(id=" + this.getId() + ", userId=" + this.getUserId() + ", pin=" + this.getPin() + ", pin2=" + this.getPin2() + ", temporary=" + this.isTemporary() + ", storePin=" + this.isStorePin() + ", storeBookings=" + this.isStoreBookings() + ", categorizeBookings=" + this.isCategorizeBookings() + ", storeAnalytics=" + this.isStoreAnalytics() + ", storeAnonymizedBookings=" + this.isStoreAnonymizedBookings() + ")";
    }
}

