/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.auth;

import de.adorsys.multibanking.utils.PrintMap;
import java.util.HashMap;
import java.util.Map;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;

public class RequestCounter {
    private Map<DocumentFQN, Counter> counterMap = new HashMap<DocumentFQN, Counter>();

    public void load(DocumentFQN fqn) {
        ++this.counter((DocumentFQN)fqn).load;
    }

    public void store(DocumentFQN fqn) {
        ++this.counter((DocumentFQN)fqn).store;
    }

    public void cacheHit(DocumentFQN fqn) {
        ++this.counter((DocumentFQN)fqn).cacheHit;
    }

    public void flush(DocumentFQN fqn) {
        ++this.counter((DocumentFQN)fqn).flush;
    }

    public void delete(DocumentFQN fqn) {
        ++this.counter((DocumentFQN)fqn).delete;
    }

    private Counter counter(DocumentFQN fqn) {
        Counter counter = this.counterMap.get(fqn);
        if (counter == null) {
            counter = new Counter();
            this.counterMap.put(fqn, counter);
        }
        return counter;
    }

    public String toString() {
        return PrintMap.print(this.counterMap);
    }

    static class Counter {
        int load;
        int cacheHit;
        int store;
        int flush;
        int delete;

        Counter() {
        }

        public String toString() {
            return "Counter [load=" + this.load + ", cacheHit=" + this.cacheHit + ", store=" + this.store + ", flush=" + this.flush + ", delete=" + this.delete + "]";
        }
    }
}

