/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.pers.spi.repository.BookingRepositoryIf;
import de.adorsys.multibanking.repository.BookingPageableRepositoryMongodb;
import de.adorsys.multibanking.repository.BookingRepositoryMongodb;
import domain.BankApi;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BookingRepositoryImpl
implements BookingRepositoryIf {
    @Autowired
    private BookingRepositoryMongodb bookingRepository;
    @Autowired
    private BookingPageableRepositoryMongodb bookingPageableRepositoryMongodb;

    public Page<BookingEntity> findPageableByUserIdAndAccountIdAndBankApi(Pageable pageable, String userId, String bankAccountId, BankApi bankApi) {
        return this.bookingPageableRepositoryMongodb.findByUserIdAndAccountIdAndBankApi(pageable, userId, bankAccountId, bankApi);
    }

    public List<BookingEntity> findByUserIdAndAccountIdAndBankApi(String userId, String bankAccountId, BankApi bankApi) {
        return this.bookingRepository.findByUserIdAndAccountIdAndBankApi(userId, bankAccountId, bankApi, new Sort(Sort.Direction.DESC, new String[]{"valutaDate"}));
    }

    public Optional<BookingEntity> findByUserIdAndId(String userId, String bookingId) {
        return this.bookingRepository.findByUserIdAndId(userId, bookingId);
    }

    public Iterable<BookingEntity> findByUserIdAndIds(String name, List<String> ids) {
        return this.bookingRepository.findAllById(ids);
    }

    public List<BookingEntity> save(List<BookingEntity> bookingEntities) {
        List newEntities = bookingEntities.stream().filter(bookingEntity -> bookingEntity.getId() == null).collect(Collectors.toList());
        List existingEntities = bookingEntities.stream().filter(bookingEntity -> bookingEntity.getId() != null).collect(Collectors.toList());
        try {
            this.bookingRepository.insert(newEntities);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
        return this.bookingRepository.saveAll(existingEntities);
    }

    public void deleteByAccountId(String id) {
        this.bookingRepository.deleteByAccountId(id);
    }

    public void deleteByUserIdAndAccountId(String userId, String accountId) {
        this.bookingRepository.deleteByUserIdAndAccountId(userId, accountId);
    }
}

