/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import de.adorsys.multibanking.repository.UserRepositoryMongodb;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class UserRepositoryImpl
implements UserRepositoryIf {
    @Autowired
    private UserRepositoryMongodb userRepository;

    public Optional<UserEntity> findById(String id) {
        return this.userRepository.findById(id);
    }

    public List<String> findExpiredUser() {
        return this.userRepository.findByExpireUserLessThan(LocalDateTime.now()).stream().map(userEntity -> userEntity.getId()).collect(Collectors.toList());
    }

    public Optional<LocalDateTime> getRulesLastChangeDate(String id) {
        return this.findById(id).flatMap(userEntity -> Optional.ofNullable(userEntity.getRulesLastChangeDate()));
    }

    public Optional<UserEntity> setRulesLastChangeDate(String id, LocalDateTime dateTime) {
        return this.findById(id).flatMap(userEntity -> {
            userEntity.setRulesLastChangeDate(dateTime);
            return Optional.of(this.userRepository.save(userEntity));
        });
    }

    public boolean exists(String userId) {
        return this.userRepository.existsById(userId);
    }

    public void save(UserEntity userEntity) {
        this.userRepository.save(userEntity);
    }

    public void delete(String userId) {
        this.userRepository.deleteById(userId);
    }
}

