/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.repository.BankAccountRepositoryMongodb;
import domain.BankAccount;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BankAccountRepositoryImpl
implements BankAccountRepositoryIf {
    @Autowired
    private BankAccountRepositoryMongodb bankAccountRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<BankAccountEntity> findByUserId(String userId) {
        return this.bankAccountRepository.findByUserId(userId);
    }

    public List<BankAccountEntity> findByUserIdAndBankAccessId(String userId, String bankAccessId) {
        return this.bankAccountRepository.findByUserIdAndBankAccessId(userId, bankAccessId);
    }

    public Optional<BankAccountEntity> findByUserIdAndId(String userId, String id) {
        return this.bankAccountRepository.findByUserIdAndId(userId, id);
    }

    public boolean exists(String accountId) {
        return this.bankAccountRepository.existsById(accountId);
    }

    public void save(List<BankAccountEntity> bankAccounts) {
        this.bankAccountRepository.saveAll(bankAccounts);
    }

    public void save(BankAccountEntity bankAccount) {
        this.bankAccountRepository.save(bankAccount);
    }

    public BankAccount.SyncStatus getSyncStatus(String accountId) {
        Query where = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)accountId));
        where.fields().include("syncStatus");
        BankAccountEntity bankAccountEntity = (BankAccountEntity)this.mongoTemplate.findOne(where, BankAccountEntity.class);
        if (bankAccountEntity != null) {
            return bankAccountEntity.getSyncStatus();
        }
        return null;
    }

    public void updateSyncStatus(String accountId, BankAccount.SyncStatus syncStatus) {
        Query where = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)accountId));
        Update update = new Update().set("syncStatus", (Object)syncStatus);
        this.mongoTemplate.updateFirst(where, update, BankAccountEntity.class);
    }

    public List<BankAccountEntity> deleteByBankAccess(String accessId) {
        return this.bankAccountRepository.deleteByBankAccessId(accessId);
    }

    public Optional<BankAccountEntity> findOne(String accountId) {
        return this.bankAccountRepository.findById(accountId);
    }
}

