/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.encrypt;

import de.adorsys.multibanking.encrypt.Encrypted;
import de.adorsys.multibanking.encrypt.EncryptionUtil;
import de.adorsys.multibanking.encrypt.UserSecret;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.stereotype.Component;

@Component
public class EncryptionEventListener
extends AbstractMongoEventListener<Object> {
    private static final String ENCRYPTION_METHOD = "AES";
    private static final String ENCRYPTION_FIELD = "encrypted";
    @Value(value="${db_secret}")
    private String databaseSecret;
    @Autowired
    private UserSecret userSecret;

    public void onBeforeSave(BeforeSaveEvent<Object> event) {
        Object source = event.getSource();
        if (!source.getClass().isAnnotationPresent(Encrypted.class)) {
            return;
        }
        Document srcDocument = event.getDocument();
        List<List<String>> excludes = this.loadExcludes(source.getClass().getAnnotation(Encrypted.class).exclude());
        Document documentWithExcludes = this.documentWithExcludes(srcDocument, excludes);
        this.removeExcludes(srcDocument, excludes);
        String fieldsForEncrypt = srcDocument.toJson();
        this.removeAllFields(srcDocument);
        srcDocument.putAll((Map)documentWithExcludes);
        srcDocument.put(ENCRYPTION_FIELD, (Object)EncryptionUtil.encrypt(fieldsForEncrypt, this.secretKey()));
    }

    public void onAfterLoad(AfterLoadEvent event) {
        Class source = event.getType();
        if (!source.isAnnotationPresent(Encrypted.class) || event.getDocument().get((Object)ENCRYPTION_FIELD) == null) {
            return;
        }
        Document document = event.getDocument();
        String decryptedJson = EncryptionUtil.decrypt(document.get((Object)ENCRYPTION_FIELD).toString(), this.secretKey());
        Document decryptedDocument = Document.parse((String)decryptedJson);
        document.putAll((Map)decryptedDocument);
    }

    private List<List<String>> loadExcludes(String[] excludes) {
        return Stream.of(excludes).map(exclude -> Arrays.asList(StringUtils.splitByWholeSeparator((String)exclude, (String)"."))).collect(Collectors.toList());
    }

    private void removeExcludes(Document document, List<List<String>> excludes) {
        if (excludes.isEmpty()) {
            return;
        }
        excludes.forEach(exclude -> {
            if (!exclude.isEmpty()) {
                document.remove(exclude.get(0));
            }
        });
    }

    private void removeAllFields(Document document) {
        String[] fields;
        for (String field : fields = document.keySet().toArray(new String[0])) {
            document.remove((Object)field);
        }
    }

    private Document documentWithExcludes(Document document, List<List<String>> excludes) {
        Document copy = new Document();
        excludes.forEach(exclude -> this.copyField((List<String>)exclude, document, copy));
        return copy;
    }

    private void copyField(List<String> excludes, Document original, Document copy) {
        if (excludes.isEmpty()) {
            return;
        }
        String field = excludes.get(0);
        Object obj = original.get((Object)field);
        if (obj != null) {
            copy.put(field, obj);
        }
        if (obj instanceof Document) {
            this.copyField(excludes.subList(1, excludes.size()), (Document)obj, (Document)copy.get((Object)field));
        }
    }

    private SecretKey secretKey() {
        return new SecretKeySpec(this.getUserSecret().getBytes(), ENCRYPTION_METHOD);
    }

    private String getUserSecret() {
        try {
            if (this.userSecret.getSecret() == null) {
                return this.databaseSecret;
            }
            return this.userSecret.getSecret();
        }
        catch (BeanCreationException e) {
            return this.databaseSecret;
        }
    }
}

