/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import de.adorsys.multibanking.repository.UserRepositoryMongodb;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class UserRepositoryImpl
implements UserRepositoryIf {
    @Autowired
    private UserRepositoryMongodb userRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public Optional<UserEntity> findById(String id) {
        return this.userRepository.findById(id);
    }

    public List<String> findExpiredUser() {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"expireUser").lte((Object)new Date()));
        query.fields().include("id");
        return this.mongoTemplate.find(query, UserEntity.class).stream().map(userEntity -> userEntity.getId()).collect(Collectors.toList());
    }

    public boolean exists(String userId) {
        return this.userRepository.existsById(userId);
    }

    public void save(UserEntity userEntity) {
        this.userRepository.save(userEntity);
    }

    public void delete(String userId) {
        this.userRepository.deleteById(userId);
    }
}

