/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.repository.BankAccessRepositoryMongodb;
import domain.BankAccess;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BankAccessRepositoryImpl
implements BankAccessRepositoryIf {
    @Autowired
    private BankAccessRepositoryMongodb bankAccessRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public Optional<BankAccessEntity> findByUserIdAndId(String userId, String id) {
        return this.bankAccessRepository.findByUserIdAndId(userId, id);
    }

    public Optional<BankAccessEntity> findOne(String id) {
        return this.bankAccessRepository.findById(id);
    }

    public List<BankAccessEntity> findByUserId(String userId) {
        return this.bankAccessRepository.findByUserId(userId);
    }

    public BankAccessEntity save(BankAccessEntity bankAccess) {
        return (BankAccessEntity)this.bankAccessRepository.save(bankAccess);
    }

    public String getBankCode(String id) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        query.fields().include("bankCode");
        BankAccess found = (BankAccess)this.mongoTemplate.findOne(query, BankAccessEntity.class);
        return found != null ? found.getBankCode() : null;
    }

    public boolean exists(String accessId) {
        return this.bankAccessRepository.existsById(accessId);
    }

    public boolean deleteByUserIdAndBankAccessId(String userId, String id) {
        return this.bankAccessRepository.deleteByUserIdAndId(userId, id) > 0L;
    }

    final class BankCodeOnly {
        private final String bankCode;

        public BankCodeOnly(String bankCode) {
            this.bankCode = bankCode;
        }

        public String getBankCode() {
            return this.bankCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BankCodeOnly)) {
                return false;
            }
            BankCodeOnly other = (BankCodeOnly)o;
            String this$bankCode = this.getBankCode();
            String other$bankCode = other.getBankCode();
            return !(this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bankCode = this.getBankCode();
            result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
            return result;
        }

        public String toString() {
            return "BankAccessRepositoryImpl.BankCodeOnly(bankCode=" + this.getBankCode() + ")";
        }
    }
}

