/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.pers.spi.repository.BankRepositoryIf;
import de.adorsys.multibanking.repository.BankRepositoryMongodb;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BankRepositoryImpl
implements BankRepositoryIf {
    @Autowired
    private BankRepositoryMongodb bankRepositoryMongodb;
    @Autowired
    private MongoTemplate mongoTemplate;

    public Optional<BankEntity> findByBankCode(String blz) {
        return this.bankRepositoryMongodb.findByBankCode(blz);
    }

    public void save(BankEntity bank) {
        this.bankRepositoryMongodb.save(bank);
    }

    public List<BankEntity> search(String text) {
        HashSet<String> terms = new HashSet<String>(Arrays.asList(text.split(" ")));
        Criteria[] criterias = (Criteria[])terms.stream().map(s -> Criteria.where((String)"searchIndex").regex(s.toLowerCase(), "iu")).toArray(Criteria[]::new);
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)new Criteria().andOperator(criterias)), BankEntity.class);
    }
}

