/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.pers.spi.repository.BookingRepositoryIf;
import de.adorsys.multibanking.repository.BookingRepositoryMongodb;
import domain.BankApi;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BookingRepositoryImpl
implements BookingRepositoryIf {
    @Autowired
    private BookingRepositoryMongodb bookingRepository;

    public List<BookingEntity> findByUserIdAndAccountIdAndBankApi(String userId, String bankAccountId, BankApi bankApi) {
        return this.bookingRepository.findByUserIdAndAccountIdAndBankApi(userId, bankAccountId, bankApi, new Sort(Sort.Direction.DESC, new String[]{"valutaDate"}));
    }

    public Optional<BookingEntity> findByUserIdAndId(String userId, String bookingId) {
        return this.bookingRepository.findByUserIdAndId(userId, bookingId);
    }

    public List<BookingEntity> save(List<BookingEntity> bookingEntities) {
        List newEntities = bookingEntities.stream().filter(bookingEntity -> bookingEntity.getId() == null).collect(Collectors.toList());
        try {
            this.bookingRepository.insert(newEntities);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
        List existingEntities = bookingEntities.stream().filter(bookingEntity -> bookingEntity.getId() != null).collect(Collectors.toList());
        return this.bookingRepository.saveAll(existingEntities);
    }

    public void deleteByAccountId(String id) {
        this.bookingRepository.deleteByAccountId(id);
    }
}

