/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import de.adorsys.multibanking.domain.RuleEntity;
import de.adorsys.multibanking.pers.spi.repository.BookingRuleRepositoryIf;
import de.adorsys.multibanking.repository.BookingRuleRepositoryMongodb;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BookingRuleRepositoryImpl
implements BookingRuleRepositoryIf {
    @Autowired
    private BookingRuleRepositoryMongodb ruleRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<RuleEntity> findByUserId(String userId) {
        return this.ruleRepository.findByUserId(userId);
    }

    public Page<RuleEntity> findAllPageable(Pageable pageable) {
        return this.ruleRepository.findAll(pageable);
    }

    public List<RuleEntity> findAll() {
        return this.ruleRepository.findAll();
    }

    public RuleEntity createOrUpdateRule(RuleEntity ruleEntity) {
        ruleEntity.updateSearchIndex();
        return (RuleEntity)this.ruleRepository.save(ruleEntity);
    }

    public List<RuleEntity> search(String text) {
        HashSet<String> terms = new HashSet<String>(Arrays.asList(text.split(" ")));
        Criteria[] criterias = (Criteria[])terms.stream().map(s -> Criteria.where((String)"searchIndex").regex(s.toLowerCase(), "iu")).toArray(Criteria[]::new);
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)new Criteria().andOperator(criterias)), RuleEntity.class);
    }

    public Optional<RuleEntity> getRuleById(String ruleId) {
        return Optional.empty();
    }

    public void deleteRule(String id) {
        this.ruleRepository.deleteById(id);
    }
}

